package toni.immersivetips.api;

import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.resources.ResourceLocation;
import toni.immersivemessages.api.ImmersiveMessage;
import toni.immersivetips.foundation.ImmersiveTip;

import java.util.List;

public interface CollectTips {
    Event<CollectTips> EVENT = EventFactory.createArrayBacked(CollectTips.class, (listeners) -> (tips) -> {
        for (CollectTips event : listeners) {
            event.onCollectTips(tips);
        }
    });

    void onCollectTips(CollectTipsContext tips);

    public class CollectTipsContext {
        List<ImmersiveTip> tips;

        public CollectTipsContext(List<ImmersiveTip> tips) {
            this.tips = tips;
        }

        public ImmersiveMessage createTip(String title, String literal) {
            var tip = new ImmersiveTip(title, literal);
            tips.add(tip);
            return tip.getMessage();
        }

        public ImmersiveMessage createTip(String title, ResourceLocation translate) {
            var tip = new ImmersiveTip(title, translate);
            tips.add(tip);
            return tip.getMessage();
        }

        public ImmersiveMessage createTip(String title, String literal, float duration) {
            var tip = new ImmersiveTip(title, literal, duration);
            tips.add(tip);
            return tip.getMessage();
        }

        public ImmersiveMessage createTip(String title, ResourceLocation translate, float duration) {
            var tip = new ImmersiveTip(title, translate, duration);
            tips.add(tip);
            return tip.getMessage();
        }
    }
}
