package toni.immersivetips.foundation.config;

import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Map.Entry;
import java.util.function.BiConsumer;
import java.util.function.Supplier;

import toni.immersivetips.ImmersiveTips;
import toni.lib.config.ConfigBase;

#if FABRIC
    import net.fabricmc.fabric.api.datagen.v1.provider.FabricLanguageProvider;
    #if after_21_1
    import net.neoforged.fml.config.ModConfig;
    import net.neoforged.neoforge.common.ModConfigSpec;
    import net.neoforged.neoforge.common.ModConfigSpec.*;
import org.apache.commons.lang3.tuple.Pair;
import net.minecraftforge.fml.config.ModConfig;
    import net.minecraftforge.common.ForgeConfigSpec;
    import net.minecraftforge.common.ForgeConfigSpec.*;
    #endif
#endif

#if FORGE
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod.EventBusSubscriber;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.ForgeConfigSpec.*;
import net.minecraftforge.fml.config.ModConfig;
#endif

#if NEO
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.common.ModConfigSpec.*;
#endif

#if FORGELIKE
@EventBusSubscriber(bus = EventBusSubscriber.Bus.MOD)
#endif
public class AllConfigs {

    private static final Map<net.minecraftforge.fml.config.ModConfig.Type, ConfigBase> CONFIGS = new EnumMap<>(net.minecraftforge.fml.config.ModConfig.Type.class);

    private static CClient client;
    private static CCommon common;
    private static CServer server;

    public static CClient client() {
        return client;
    }

    public static CCommon common() {
        return common;
    }

    public static CServer server() {
        return server;
    }

    public static ConfigBase byType(net.minecraftforge.fml.config.ModConfig.Type type) {
        return CONFIGS.get(type);
    }

    private static <T extends ConfigBase> T register(Supplier<T> factory, net.minecraftforge.fml.config.ModConfig.Type side) {
        var specPair = new Builder().configure(builder -> {
            T config = factory.get();
            config.registerAll(builder);
            return config;
        });

        T config = specPair.getLeft();
        config.specification = specPair.getRight();
        CONFIGS.put(side, config);
        return config;
    }

    public static void register(BiConsumer<ModConfig.Type, #if after_21_1 ModConfigSpec #else ForgeConfigSpec #endif> registration) {
        if (!ImmersiveTips.isDedicatedServer())
            client = register(CClient::new, ModConfig.Type.CLIENT);

        common = register(CCommon::new, ModConfig.Type.COMMON);
        server = register(CServer::new, ModConfig.Type.SERVER);

        for (Entry<ModConfig.Type, ConfigBase> pair : CONFIGS.entrySet())
            registration.accept(pair.getKey(), pair.getValue().specification);
    }

    #if FABRIC
    public static void generateTranslations(FabricLanguageProvider.TranslationBuilder translationBuilder) {
        var existing = new HashSet<String>();

        for (Entry<net.minecraftforge.fml.config.ModConfig.Type, ConfigBase> pair : CONFIGS.entrySet())
        {
            for (var entry : pair.getValue().specification.getSpec().entrySet()) {
                if (existing.add(entry.getKey()))
                    translationBuilder.add(ImmersiveTips.ID + ".configuration." + entry.getKey(), entry.getKey());
            }
        }
    }
    #endif

    #if FORGELIKE
    @net.minecraftforge.eventbus.api.SubscribeEvent
    public static void onLoad(net.minecraftforge.fml.event.config.ModConfigEvent.Loading event) {
        for (ConfigBase config : CONFIGS.values())
            if (config.specification == event.getConfig().getSpec())
                config.onLoad();
    }

    @net.minecraftforge.eventbus.api.SubscribeEvent
    public static void onReload(net.minecraftforge.fml.event.config.ModConfigEvent.Reloading event) {
        for (ConfigBase config : CONFIGS.values())
            if (config.specification == event.getConfig().getSpec())
                config.onReload();
    }
    #endif
}