package toni.immersivetips.foundation.config;

import toni.lib.config.ConfigBase;

import java.util.ArrayList;
import java.util.List;

#if FABRIC
    import net.fabricmc.fabric.api.datagen.v1.provider.FabricLanguageProvider;
    #if after_21_1
    import net.neoforged.fml.config.ModConfig;
    import net.neoforged.neoforge.common.ModConfigSpec;
    import net.neoforged.neoforge.common.ModConfigSpec.*;
    #else
    import net.minecraftforge.fml.config.ModConfig;
    import net.minecraftforge.common.ForgeConfigSpec;
    import net.minecraftforge.common.ForgeConfigSpec.*;
    #endif
#endif

#if FORGE
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod.EventBusSubscriber;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.ForgeConfigSpec.*;
import net.minecraftforge.fml.config.ModConfig;
#endif

#if NEO
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.common.ModConfigSpec.*;
#endif

public class CClient extends ConfigBase {
    public final CValue<List<String>, ConfigValue<List<String>>> whitelistedScreens
        = new CValue<>("Whitelisted Screens", builder -> builder.define("Whitelisted Screens", new ArrayList<>()), "Sets screens to manually enable tips on.");

    public final CValue<List<String>, ConfigValue<List<String>>> blacklistedScreens
        = new CValue<>("Blacklisted Screens", builder -> builder.define("Blacklisted Screens", new ArrayList<>()), "Sets screens to manually disable tips on.");


    public final CValue<Boolean, ConfigValue<Boolean>> enableLegacyTips
        = new CValue<>("Enable Legacy Tips",
        builder -> builder.define("Enable Legacy Tips", true),
        "Loads included default tips from the legacy format.");

    public final CValue<Boolean, ConfigValue<Boolean>> enableRemoteLoadingTips
        = new CValue<>("Enable Remote Loading Screen Tips",
        builder -> builder.define("Enable Remote Loading Screen Tips", true),
        "Loads remote tips from GitHub for the loading screen.");

    public final CValue<Boolean, ConfigValue<Boolean>> enableRemoteItemTips
        = new CValue<>("Enable Remote Item Tips",
        builder -> builder.define("Enable Remote Item Tips", true),
        "Loads remote item tooltips from GitHub.");

    public final CValue<Boolean, ConfigValue<Boolean>> enableOnLoadingScreens
        = new CValue<>("Enable On Loading Screens",
        builder -> builder.define("Enable On Loading Screens", true),
        "If disabled, will only show on the pause and death screens.");

    public final CValue<Boolean, ConfigValue<Boolean>> enableOnPauseScreen
        = new CValue<>("Enable On Pause Screen",
        builder -> builder.define("Enable On Pause Screen", true),
        "If disabled, will only show on the loading and death screens.");

    public final CValue<Boolean, ConfigValue<Boolean>> enableOnDeathScreen
        = new CValue<>("Enable On Death Screen",
        builder -> builder.define("Enable On Death Screen", true),
        "If disabled, will only show on the pause and loading screens.");



    @Override
    public String getName() {
        return "client";
    }
}