package toni.immersivetips;

import net.fabricmc.fabric.api.client.item.v1.ItemTooltipCallback;
import net.minecraft.class_437;
import net.minecraft.client.gui.screens.*;
import toni.immersivetips.api.CollectTips;
import toni.immersivetips.api.ModifyTip;
import toni.immersivetips.foundation.ImmersiveTip;
import toni.immersivetips.foundation.config.AllConfigs;
import toni.immersivetips.foundation.data.RemoteTipConfig;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

#if FABRIC
    #if after_21_1
import fuzs.forgeconfigapiport.fabric.api.neoforge.v4.client.ConfigScreenFactoryRegistry;
        import net.neoforged.neoforge.client.gui.ConfigurationScreen;
        #endif

    #if current_20_1
    #endif
#endif

public class ImmersiveTipsClient {
    public static Set<Class<? extends class_437>> EnabledScreens = new HashSet<>();


    public static void init() {
        #if AFTER_21_1
            #if FABRIC
            ConfigScreenFactoryRegistry.INSTANCE.register(ImmersiveTips.ID, ConfigurationScreen::new);
            #endif
        #endif

        if (AllConfigs.client().enableOnLoadingScreens.get()) {
            addEnabledScreen(LevelLoadingScreen.class);
            addEnabledScreen(ProgressScreen.class);
            addEnabledScreen(ConnectScreen.class);
            addEnabledScreen(DisconnectedScreen.class);
            #if AFTER_21_1
            addEnabledScreen(GenericMessageScreen.class);
            #endif
        }

        if (AllConfigs.client().enableOnDeathScreen.get())
            addEnabledScreen(DeathScreen.class);


        if (AllConfigs.client().enableOnPauseScreen.get())
            addEnabledScreen(PauseScreen.class);


        ItemTooltipCallback.EVENT.register((item, context, #if mc >= 211 flag, #endif list) -> {
            var tips = ImmersiveTips.ItemTooltips.get(item.getItem().builtInRegistryHolder().key().location());
            if (tips != null) {
                list.addAll(tips);
            }
        });

        if (!AllConfigs.client().enableRemoteItemTips.get() && !AllConfigs.client().enableRemoteLoadingTips.get())
            return;

        String url = "https://raw.githubusercontent.com/txnimc/ImmersiveTips/refs/heads/main/tooltips.json";
        CompletableFuture.runAsync(() -> RemoteTipConfig.fetchAndParseJson(url));
    }

    public static void addEnabledScreen(Class<? extends class_437> screenClass) {
        EnabledScreens.add(screenClass);
    }
}
