package toni.immersivetips.foundation;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import toni.immersivemessages.api.ImmersiveMessage;
import toni.immersivemessages.api.TextAnchor;
import toni.immersivetips.api.ModifyTip;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3542;

public class ImmersiveTip {
    public static final Codec<ImmersiveTip> CODEC = RecordCodecBuilder.create(instance ->
        instance.group(
            Codec.STRING.optionalFieldOf("title").forGetter((tip) -> Optional.ofNullable(tip.title)),
            Codec.STRING.optionalFieldOf("literal").forGetter((tip) -> Optional.ofNullable(tip.literal)),
            Codec.STRING.optionalFieldOf("condition").forGetter((tip) -> Optional.ofNullable(tip.condition)),
            class_2960.field_25139.optionalFieldOf("translate").forGetter((tip) -> Optional.ofNullable(tip.translate)),
            Codec.FLOAT.optionalFieldOf("duration").forGetter((tip) -> Optional.of(tip.duration)),
            Codec.INT.optionalFieldOf("multiplier").forGetter((tip) -> Optional.of(tip.multiplier)),
            Priority.CODEC.optionalFieldOf("priority").forGetter((tip) -> Optional.of(tip.priority))
        ).apply(instance, ImmersiveTip::new)
    );

    private ImmersiveMessage cachedMessage;

    public String title;
    public String literal = "";
    public class_2960 translate;

    public Priority priority = Priority.LOW;
    public float duration = 15f;
    public int multiplier = -1;
    public String condition = "";

    public ImmersiveTip(String title, String literal) {
        this.title = title;
        this.literal = literal;
    }

    public ImmersiveTip(String title, class_2960 translate) {
        this.title = title;
        this.translate = translate;
    }

    public ImmersiveTip(String title, String literal, float duration) {
        this.title = title;
        this.literal = literal;
        this.duration = duration;
    }

    public ImmersiveTip(String title, class_2960 translate, float duration) {
        this.title = title;
        this.translate = translate;
        this.duration = duration;
    }

    public ImmersiveTip(
        Optional<String> title,
        Optional<String> literal,
        Optional<String> condition,
        Optional<class_2960> translate,
        Optional<Float> duration,
        Optional<Integer> multiplier,
        Optional<Priority> priority)
    {
        this.title = title.orElse("Tip");
        this.literal = literal.orElse("");
        this.condition = condition.orElse("");
        this.translate = translate.orElse(null);
        this.duration = duration.orElse(15f);
        this.multiplier = multiplier.orElse(-1);
        this.priority = priority.orElse(Priority.MEDIUM);
    }

    public ImmersiveMessage getMessage() {
        if (cachedMessage != null)
            return cachedMessage;

        this.cachedMessage = ImmersiveMessage.builder(duration, title)
            .anchor(TextAnchor.BOTTOM_LEFT)
            .wrap()
            .y(0f)
            .size(1f)
            .slideLeft(0.3f)
            .slideOutRight(0.3f)
            .fadeIn(0.5f)
            .fadeOut(0.5f)
            .color(class_124.field_1065)
            .style(style -> style.method_30938(true))
            .subtext(0f, getText(), 11f, (subtext) -> subtext
                .anchor(TextAnchor.BOTTOM_LEFT)
                .wrap()
                .size(1f)
                .slideLeft(0.3f)
                .slideOutRight(0.3f)
                .fadeIn(0.5f)
                .fadeOut(0.5f)
            );

        ModifyTip.EVENT.invoker().onTipCreate(this.cachedMessage);

        return cachedMessage;
    }


    public int hashCode() {
        return ((translate != null ? translate.method_12832() : "") + literal).hashCode();
    }

    private String getText() {
        return translate == null ? literal : class_2561.method_48321(translate.method_12832(), literal).getString();
    }

    public enum Priority implements class_3542 {
        LOW("low"),
        MEDIUM("medium"),
        HIGH("high"),
        IMMEDIATE("immediate");

        public static final Codec<Priority> CODEC = class_3542.method_28140(Priority::values);
        public static final List<Priority> VALUES = Arrays.stream(Priority.values()).toList();

        private final String name;

        Priority(String name) {
            this.name = name;
        }

        @Override
        public String method_15434() {
            return name;
        }
    }
}
