/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.hdskins.client;

import com.minelittlepony.hdskins.Memoize;
import com.minelittlepony.hdskins.client.HDSkins;
import com.minelittlepony.hdskins.client.profile.DynamicSkinTextures;
import com.minelittlepony.hdskins.profile.SkinType;
import com.mojang.authlib.GameProfile;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import net.minecraft.class_12079;
import net.minecraft.class_2960;
import net.minecraft.class_8685;

public record PlayerSkinLayers(Layer vanilla, Layer hd, Layer combined) {
    private static final AtomicLong TIMESTAMP = new AtomicLong(System.currentTimeMillis());

    public static void invalidateCaches() {
        TIMESTAMP.set(System.currentTimeMillis());
    }

    public boolean hasChanged() {
        return this.vanilla.dynamic().hasChanged() || this.hd.dynamic().hasChanged() || this.combined.dynamic().hasChanged();
    }

    public static PlayerSkinLayers of(GameProfile profile, Supplier<class_8685> vanillaSkins) {
        Layer vanilla = new Layer(DynamicSkinTextures.of(vanillaSkins), Memoize.withForcedExpiration(vanillaSkins, TIMESTAMP));
        Layer hd = new Layer(HDSkins.getInstance().getResourceManager().getSkinTextures(profile).union(HDSkins.getInstance().getProfileRepository().get(profile)));
        Layer combined = new Layer(hd.dynamic().union(vanilla.dynamic()));
        return new PlayerSkinLayers(vanilla, hd, combined);
    }

    public record Layer(DynamicSkinTextures dynamic, Memoize<class_8685> resolved) {
        public Layer(DynamicSkinTextures dynamic) {
            this(dynamic, Memoize.withExpiration(() -> DynamicSkinTextures.toSkinTextures(dynamic)));
        }

        public Set<class_2960> getProvidedSkinTypes() {
            return this.dynamic().getProvidedSkinTypes();
        }

        public Optional<class_12079.class_12081> getSkin(SkinType type) {
            return this.dynamic().getSkin(type);
        }

        public Optional<String> getModel() {
            return this.dynamic().getModel();
        }

        public class_8685 getSkinTextures() {
            if (this.dynamic().hasChanged()) {
                this.resolved.expireNow();
            }
            return (class_8685)this.resolved.get();
        }
    }
}

