/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.hdskins.client;

import com.minelittlepony.hdskins.client.PlayerSkinLayers;
import com.minelittlepony.hdskins.client.profile.DynamicSkinTextures;
import com.minelittlepony.hdskins.profile.SkinType;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_12079;
import net.minecraft.class_2960;

public class PrioritySorter {
    private final List<Selector> selectors = new ArrayList<Selector>();

    public void addSelector(Selector selector) {
        this.selectors.add(selector);
    }

    public PlayerSkinLayers.Layer selectBest(SkinType type, final PlayerSkinLayers skins) {
        if (this.selectors.isEmpty()) {
            return skins.combined();
        }
        if (this.selectors.size() == 1) {
            return this.selectors.get(0).selectBest(type, skins);
        }
        var best = new Object(this){
            PlayerSkinLayers.Layer best;
            int bestCount;
            {
                this.best = skins.combined();
                this.bestCount = 0;
            }
        };
        Object2IntOpenHashMap picks = new Object2IntOpenHashMap();
        this.selectors.forEach(selector -> picks.computeInt((Object)selector.selectBest(type, skins), (pick, count) -> {
            if ((count = Integer.valueOf(count == null ? 1 : count + 1)) > best.bestCount) {
                best.best = pick;
            }
            return count;
        }));
        return best.best;
    }

    public DynamicSkinTextures createDynamicTextures(final PlayerSkinLayers playerSkins) {
        return new DynamicSkinTextures(){

            @Override
            public Set<class_2960> getProvidedSkinTypes() {
                return playerSkins.combined().dynamic().getProvidedSkinTypes();
            }

            @Override
            public Optional<class_12079.class_12081> getSkin(SkinType type) {
                if (PrioritySorter.this.selectors.isEmpty()) {
                    return playerSkins.combined().dynamic().getSkin(type);
                }
                return PrioritySorter.this.selectBest(type, playerSkins).getSkin(type);
            }

            @Override
            public Optional<String> getModel() {
                if (PrioritySorter.this.selectors.isEmpty()) {
                    return playerSkins.combined().dynamic().getModel();
                }
                return PrioritySorter.this.selectBest(SkinType.SKIN, playerSkins).dynamic().getModel();
            }

            @Override
            public boolean hasChanged() {
                return playerSkins.hasChanged();
            }
        };
    }

    public static interface Selector {
        public PlayerSkinLayers.Layer selectBest(SkinType var1, PlayerSkinLayers var2);
    }
}

