/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.hdskins.client.gui;

import com.minelittlepony.common.client.gui.ITextContext;
import com.minelittlepony.common.client.gui.dimension.Bounds;
import com.minelittlepony.hdskins.client.gui.PlayerBodyWidget;
import com.minelittlepony.hdskins.client.gui.player.skins.PlayerSkins;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_10055;
import net.minecraft.class_11909;
import net.minecraft.class_1268;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import org.joml.Quaternionf;

public class Carousel<T extends PlayerSkins<? extends PlayerSkins.PlayerSkin>, S extends class_10055>
implements Closeable,
ITextContext {
    public static final int HOR_MARGIN = 30;
    private static final int TOP = 50;
    private final class_2561 title;
    private final PlayerBodyWidget<S> entity;
    private final T skins;
    public final Bounds bounds = new Bounds(50, 30, 0, 0);
    private final List<Element> elements = new ArrayList<Element>();

    public Carousel(class_2561 title, T skins, Function<PlayerSkins<?>, PlayerBodyWidget<S>> playerFactory) {
        this.title = title;
        this.skins = skins;
        this.entity = playerFactory.apply((PlayerSkins<?>)skins);
        this.addElement(this.entity);
    }

    public void addElement(Element element) {
        this.elements.add(element);
    }

    public PlayerBodyWidget<S> getEntity() {
        return this.entity;
    }

    public T getSkins() {
        return this.skins;
    }

    public boolean mouseClicked(int width, int height, class_11909 click) {
        if (this.bounds.contains(click.comp_4798(), click.comp_4799())) {
            this.entity.swingArm(click.method_74245() == 0 ? class_1268.field_5808 : class_1268.field_5810);
            return true;
        }
        return false;
    }

    public void update() {
        this.elements.forEach(Element::tick);
    }

    public void render(int mouseX, int mouseY, int rotationAngle, float partialTick, class_332 context) {
        context.method_44379(this.bounds.left, this.bounds.top, this.bounds.right(), this.bounds.bottom());
        int horizon = this.bounds.bottom() - 50;
        this.drawBackground(context, horizon);
        Quaternionf rotation = new Quaternionf().rotationX((float)Math.PI).rotateY((float)rotationAngle / 20.0f);
        this.elements.forEach(element -> {
            element.updateState(this.bounds.left + this.bounds.width / 2, (float)this.bounds.top + (float)this.bounds.height * 0.9f, mouseX, this.bounds.top + this.bounds.height / 2 - mouseY, partialTick);
            element.render(context, this.bounds, mouseX, mouseY, rotation);
        });
        context.method_44380();
        context.method_51448().pushMatrix();
        this.bounds.translate(context.method_51448());
        context.method_51439(this.getFont(), this.title, 5, 5, -1, false);
        context.method_51448().popMatrix();
    }

    protected void drawBackground(class_332 context, int horizon) {
        this.bounds.draw(context, -1610612736);
        context.method_25296(this.bounds.left, horizon, this.bounds.right(), this.bounds.bottom(), 0x5FFFFFF, 0x40FFFFFF);
    }

    @Override
    public void close() {
        ((PlayerSkins)this.skins).close();
    }

    public static interface Element {
        public void tick();

        public void updateState(float var1, float var2, float var3, float var4, float var5);

        public void render(class_332 var1, Bounds var2, int var3, int var4, Quaternionf var5);
    }
}

