/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.hdskins.client.gui.player.skins;

import com.minelittlepony.common.client.gui.sprite.ISprite;
import com.minelittlepony.common.client.gui.sprite.TextureSprite;
import com.minelittlepony.common.client.gui.style.Style;
import com.minelittlepony.hdskins.client.HDSkins;
import com.minelittlepony.hdskins.client.VanillaModels;
import com.minelittlepony.hdskins.client.VanillaSkins;
import com.minelittlepony.hdskins.client.gui.GuiSkins;
import com.minelittlepony.hdskins.client.resources.EquipmentList;
import com.minelittlepony.hdskins.client.resources.NativeImageFilters;
import com.minelittlepony.hdskins.client.resources.TextureLoader;
import com.minelittlepony.hdskins.profile.SkinType;
import com.mojang.authlib.GameProfile;
import java.io.Closeable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.class_12079;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4050;
import net.minecraft.class_7920;
import net.minecraft.class_8685;
import org.jetbrains.annotations.Nullable;

public abstract class PlayerSkins<T extends PlayerSkin>
implements Closeable {
    public static final PlayerSkins<PlayerSkin> EMPTY = new PlayerSkins<PlayerSkin>(Posture.NULL){

        @Override
        public PlayerSkin createTexture(SkinType type, final Supplier<class_2960> blank) {
            return new PlayerSkin(){

                @Override
                public class_2960 getId() {
                    return (class_2960)blank.get();
                }

                @Override
                public void close() {
                }

                @Override
                public boolean isReady() {
                    return false;
                }
            };
        }

        @Override
        protected boolean isProvided(SkinType type) {
            return false;
        }

        @Override
        public String getSkinVariant() {
            return "default";
        }
    };
    protected final Map<SkinType, T> textures = new HashMap<SkinType, T>();
    @Nullable
    private Set<class_2960> providedSkinTypes;
    @Nullable
    private class_8685 bundle;
    private long setAt;
    private final Posture posture;

    protected PlayerSkins(Posture posture) {
        this.posture = posture;
    }

    protected abstract T createTexture(SkinType var1, Supplier<class_2960> var2);

    public Posture getPosture() {
        return this.posture;
    }

    public abstract String getSkinVariant();

    public T get(SkinType type) {
        return (T)this.textures.computeIfAbsent(type, t -> this.createTexture((SkinType)t, () -> this.posture.getDefaultSkin((SkinType)t, this.getSkinVariant())));
    }

    public boolean hasAny() {
        return this.textures.values().stream().anyMatch(PlayerSkin::isReady);
    }

    public Set<class_2960> getProvidedSkinTypes() {
        long now = System.currentTimeMillis();
        if (this.providedSkinTypes == null || this.setAt < now) {
            this.setAt = now + 500L;
            this.providedSkinTypes = SkinType.REGISTRY.method_10220().filter(this::isProvided).map(SkinType::getId).collect(Collectors.toSet());
        }
        return this.providedSkinTypes;
    }

    protected abstract boolean isProvided(SkinType var1);

    public class_8685 getSkinTextureBundle() {
        class_12079.class_12081 skinId = this.get(SkinType.SKIN).getAsset();
        return class_8685.method_74884((class_12079.class_12081)(this.getPosture().getActiveSkinType() == SkinType.SKIN ? skinId : this.getGreyScaleSkin(skinId)), (class_12079.class_12081)(this.getPosture().getActiveSkinType() == SkinType.CAPE ? this.get(SkinType.CAPE).getAsset() : null), (class_12079.class_12081)(this.getPosture().getActiveSkinType() == SkinType.ELYTRA ? this.get(SkinType.ELYTRA).getAsset() : null), (class_7920)(VanillaModels.isSlim(this.getSkinVariant()) ? class_7920.field_41122 : class_7920.field_41123));
    }

    private class_12079.class_12081 getGreyScaleSkin(class_12079.class_12081 asset) {
        class_2960 newPath = NativeImageFilters.REDUCE_ALPHA.load(asset.comp_3627(), asset.comp_3627(), this.getPosture().getExclusion());
        if (newPath.equals((Object)asset.comp_3627())) {
            return asset;
        }
        return new class_12079.class_10726(asset.comp_3626().method_48331("_greyscaled"), newPath);
    }

    @Override
    public void close() {
        this.textures.values().forEach(PlayerSkin::close);
        this.textures.clear();
        this.providedSkinTypes = null;
        this.bundle = null;
    }

    public static interface Posture {
        public static final Posture NULL = new Posture(){

            @Override
            public GameProfile getProfile() {
                return class_310.method_1551().method_53462();
            }

            @Override
            public Pose getPose() {
                return Pose.STAND;
            }

            @Override
            public SkinType getActiveSkinType() {
                return SkinType.SKIN;
            }

            @Override
            public Optional<SkinVariant> getSkinVariant() {
                return Optional.empty();
            }

            @Override
            public class_2960 getDefaultSkin(SkinType type, String variant) {
                return VanillaSkins.getDefaultTexture(type, variant);
            }

            @Override
            public EquipmentList.EquipmentSet getEquipment() {
                return HDSkins.getInstance().getDummyPlayerEquipmentList().getDefault();
            }

            @Override
            public TextureLoader.Exclusion getExclusion() {
                return TextureLoader.Exclusion.NULL;
            }
        };

        public GameProfile getProfile();

        public EquipmentList.EquipmentSet getEquipment();

        public Pose getPose();

        public SkinType getActiveSkinType();

        public Optional<SkinVariant> getSkinVariant();

        public class_2960 getDefaultSkin(SkinType var1, String var2);

        public TextureLoader.Exclusion getExclusion();

        public static enum Pose {
            STAND(class_4050.field_18076),
            SLEEP(class_4050.field_18078),
            RIDE(class_4050.field_40118),
            SWIM(class_4050.field_18079),
            RIPTIDE(class_4050.field_18080);

            public static final Pose[] VALUES;
            public static final Style[] STYLES;
            private final Style style = new Style().setIcon((ISprite)new TextureSprite().setTexture(GuiSkins.WIDGETS_TEXTURE).setPosition(2, 2).setSize(16, 16).setTextureOffset(96, 16 * this.ordinal())).setTooltip((class_2561)class_2561.method_43469((String)"hdskins.mode", (Object[])new Object[]{class_2561.method_43471((String)("hdskins.mode." + this.name().toLowerCase(Locale.ROOT)))}), 0, 10);
            private final class_4050 pose;

            private Pose(class_4050 pose) {
                this.pose = pose;
            }

            public Style getStyle() {
                return this.style;
            }

            public class_4050 getPose() {
                return this.pose;
            }

            static {
                VALUES = Pose.values();
                STYLES = (Style[])Arrays.stream(VALUES).map(Pose::getStyle).toArray(Style[]::new);
            }
        }

        public record SkinVariant(class_2561 tooltip, ISprite icon, String name) {
            public static final Set<SkinVariant> VALUES = new HashSet<SkinVariant>();
            public static final SkinVariant DEFAULT = new SkinVariant(HDSkins.id("default"));
            public static final SkinVariant SLIM = new SkinVariant(HDSkins.id(VanillaModels.SLIM));

            public SkinVariant(class_2960 id) {
                this((class_2561)class_2561.method_43469((String)"hdskins.arm_style", (Object[])new Object[]{class_2561.method_43471((String)(id.method_12836() + ".arm_style." + id.method_12832()))}), (ISprite)GuiSkins.createIcon(32, 16 * VALUES.size()), id.method_12832());
                VALUES.add(this);
            }
        }
    }

    public static interface PlayerSkin
    extends Closeable {
        public class_2960 getId();

        default public class_12079.class_12081 getAsset() {
            class_2960 id = this.getId();
            return new class_12079.class_10726(id, id);
        }

        @Override
        public void close();

        public boolean isReady();
    }

    public static interface SkinFactory<T extends PlayerSkin, K extends PlayerSkins<? extends T>> {
        public T create(SkinType var1, Supplier<class_2960> var2, K var3);
    }
}

