/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.hdskins.server;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.minelittlepony.hdskins.server.ServerType;
import com.minelittlepony.hdskins.server.SkinServer;
import com.minelittlepony.hdskins.server.ValhallaSkinServer;
import com.minelittlepony.hdskins.server.YggdrasilSkinServer;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;

public class SkinServerSerializer
implements JsonSerializer<SkinServer>,
JsonDeserializer<SkinServer> {
    public static final SkinServerSerializer INSTANCE = new SkinServerSerializer();
    private final BiMap<String, Class<? extends SkinServer>> types = HashBiMap.create((int)2);

    private SkinServerSerializer() {
        this.addSkinServerType(ValhallaSkinServer.class);
        this.addSkinServerType(YggdrasilSkinServer.class);
    }

    public void addSkinServerType(Class<? extends SkinServer> type) {
        Preconditions.checkArgument((!type.isInterface() ? 1 : 0) != 0, (Object)"type cannot be an interface");
        Preconditions.checkArgument((!Modifier.isAbstract(type.getModifiers()) ? 1 : 0) != 0, (Object)"type cannot be abstract");
        ServerType st = type.getAnnotation(ServerType.class);
        if (st == null) {
            throw new IllegalArgumentException("class is not annotated with @ServerType");
        }
        this.types.put((Object)st.value(), type);
    }

    public JsonElement serialize(SkinServer src, Type typeOfSrc, JsonSerializationContext context) {
        ServerType serverType = src.getClass().getAnnotation(ServerType.class);
        if (serverType == null) {
            throw new JsonIOException("Skin server class did not have a type: " + String.valueOf(typeOfSrc));
        }
        JsonObject obj = context.serialize((Object)src).getAsJsonObject();
        obj.addProperty("type", serverType.value());
        return obj;
    }

    public SkinServer deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        String type = json.getAsJsonObject().get("type").getAsString();
        return (SkinServer)context.deserialize(json, (Type)this.types.get((Object)type));
    }
}

