/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.hdskins;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.Nullable;

public interface Memoize<T>
extends java.util.function.Supplier<T> {
    default public void expireNow() {
    }

    public static <T> Memoize<T> basic(final java.util.function.Supplier<T> supplier) {
        return new Memoize<T>(){
            @Nullable
            private Optional<T> value;

            @Override
            @Nullable
            public T get() {
                if (this.value == null) {
                    this.value = Optional.ofNullable(supplier.get());
                }
                return this.value.orElse(null);
            }

            @Override
            public void expireNow() {
                this.value = null;
            }
        };
    }

    public static <T> Memoize<T> nonExpiring(java.util.function.Supplier<T> supplier) {
        return supplier::get;
    }

    public static <T> Memoize<T> withForcedExpiration(final java.util.function.Supplier<T> supplier, final AtomicLong timestamp) {
        return new Memoize<T>(){
            private long lastTimestamp;
            private java.util.function.Supplier<T> value;
            {
                this.lastTimestamp = timestamp.get();
                this.value = () -> ((Supplier)Suppliers.memoizeWithExpiration(((java.util.function.Supplier)supplier)::get, (long)1L, (TimeUnit)TimeUnit.SECONDS)).get();
            }

            @Override
            public T get() {
                long time = timestamp.get();
                if (time != this.lastTimestamp) {
                    this.expireNow();
                }
                return this.value.get();
            }

            @Override
            public void expireNow() {
                this.value = () -> ((Supplier)Suppliers.memoizeWithExpiration(((java.util.function.Supplier)supplier)::get, (long)1L, (TimeUnit)TimeUnit.SECONDS)).get();
            }
        };
    }

    public static <T> Memoize<T> withExpiration(final java.util.function.Supplier<T> supplier) {
        return new Memoize<T>(){
            private java.util.function.Supplier<T> value = () -> ((Supplier)Suppliers.memoizeWithExpiration(((java.util.function.Supplier)supplier)::get, (long)1L, (TimeUnit)TimeUnit.SECONDS)).get();

            @Override
            public T get() {
                return this.value.get();
            }

            @Override
            public void expireNow() {
                this.value = () -> ((Supplier)Suppliers.memoizeWithExpiration(((java.util.function.Supplier)supplier)::get, (long)1L, (TimeUnit)TimeUnit.SECONDS)).get();
            }
        };
    }

    public static <K, V> LoadingCache<K, CompletableFuture<V>> createAsyncLoadingCache(long retentionPeriod, Function<K, CompletableFuture<V>> loadFunction) {
        return CacheBuilder.newBuilder().expireAfterAccess(retentionPeriod, TimeUnit.SECONDS).removalListener(entry -> ((CompletableFuture)entry.getValue()).cancel(false)).build(CacheLoader.from(loadFunction));
    }
}

