/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.hdskins.client;

import com.minelittlepony.common.client.gui.VisibilityMode;
import com.minelittlepony.common.client.gui.element.Button;
import com.minelittlepony.common.event.ScreenInitCallback;
import com.minelittlepony.common.util.GamePaths;
import com.minelittlepony.hdskins.HDSkinsServer;
import com.minelittlepony.hdskins.client.HDConfig;
import com.minelittlepony.hdskins.client.PrioritySorter;
import com.minelittlepony.hdskins.client.gui.GuiSkins;
import com.minelittlepony.hdskins.client.gui.PlayerPreviewSpecialGuiElementRenderer;
import com.minelittlepony.hdskins.client.gui.SettingsScreen;
import com.minelittlepony.hdskins.client.profile.SkinLoader;
import com.minelittlepony.hdskins.client.resources.EquipmentList;
import com.minelittlepony.hdskins.client.resources.SkinResourceManager;
import com.minelittlepony.hdskins.server.SkinServerList;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.rendering.v1.SpecialGuiElementRegistry;
import net.fabricmc.fabric.api.resource.v1.ResourceLoader;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_3302;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_442;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class HDSkins
implements ClientModInitializer {
    public static final Logger LOGGER = LogManager.getLogger();
    private static HDSkins instance;
    private final HDConfig config = new HDConfig(GamePaths.getConfigDirectory().resolve("hdskins.json"));
    private final EquipmentList equipmentList = new EquipmentList();
    private final SkinResourceManager resources = new SkinResourceManager();
    private final SkinLoader repository = new SkinLoader();
    private final PrioritySorter skinPrioritySorter = new PrioritySorter();
    private boolean configDirty;

    public static HDSkins getInstance() {
        return instance;
    }

    public static class_2960 id(String name) {
        return HDSkinsServer.id(name);
    }

    public HDSkins() {
        instance = this;
    }

    public HDConfig getConfig() {
        return this.config;
    }

    public void onInitializeClient() {
        this.config.load();
        SpecialGuiElementRegistry.register(PlayerPreviewSpecialGuiElementRenderer::new);
        HDSkinsServer.getInstance().setSessionService(() -> class_310.method_1551().method_73361().comp_837());
        ResourceLoader.get((class_3264)class_3264.field_14188).registerReloader(SkinResourceManager.ID, (class_3302)this.resources);
        ResourceLoader.get((class_3264)class_3264.field_14188).registerReloader(SkinServerList.SKIN_SERVERS, (class_3302)HDSkinsServer.getInstance().getServers());
        ResourceLoader.get((class_3264)class_3264.field_14188).registerReloader(EquipmentList.EQUIPMENT, (class_3302)this.equipmentList);
        ScreenInitCallback.EVENT.register(this::onScreenInit);
        FabricLoader.getInstance().getEntrypoints("hdskins", ClientModInitializer.class).forEach(ClientModInitializer::onInitializeClient);
        ClientTickEvents.END_CLIENT_TICK.register(this::onTick);
        this.config.onChangedExternally(config -> {
            this.configDirty = true;
        });
    }

    private void onTick(class_310 client) {
        class_437 class_4372;
        if (this.configDirty && (class_4372 = client.field_1755) instanceof SettingsScreen) {
            SettingsScreen screen = (SettingsScreen)class_4372;
            screen.method_25423(client, screen.field_22789, screen.field_22790);
        }
        this.configDirty = false;
    }

    private void onScreenInit(class_437 screen, ScreenInitCallback.ButtonList buttons) {
        if (!(screen instanceof class_442)) {
            return;
        }
        VisibilityMode visibility = (VisibilityMode)this.config.pantsButtonVisibility.get();
        if (visibility == VisibilityMode.OFF || visibility == VisibilityMode.AUTO && FabricLoader.getInstance().isModLoaded("modmenu")) {
            return;
        }
        Button button = ((Button)buttons.addButton((class_364)new Button(screen.field_22789 - 50, screen.field_22790 - 50, 20, 20))).onClick(sender -> class_310.method_1551().method_1507((class_437)GuiSkins.create(screen, HDSkinsServer.getInstance().getServers())));
        button.getStyle().setIcon(new class_1799((class_1935)class_1802.field_8570), 3956171).setTooltip("hdskins.manager", 0, 10);
        button.method_46419(screen.field_22790 - 50);
    }

    public SkinResourceManager getResourceManager() {
        return this.resources;
    }

    public SkinLoader getProfileRepository() {
        return this.repository;
    }

    @Deprecated
    public SkinServerList getSkinServerList() {
        return HDSkinsServer.getInstance().getServers();
    }

    public EquipmentList getDummyPlayerEquipmentList() {
        return this.equipmentList;
    }

    public PrioritySorter getSkinPrioritySorter() {
        return this.skinPrioritySorter;
    }
}

