/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.hdskins.client.gui;

import com.google.common.base.Preconditions;
import com.minelittlepony.common.client.gui.GameGui;
import com.minelittlepony.common.client.gui.Tooltip;
import com.minelittlepony.common.client.gui.dimension.Bounds;
import com.minelittlepony.common.client.gui.element.Button;
import com.minelittlepony.common.client.gui.element.Cycler;
import com.minelittlepony.common.client.gui.element.Label;
import com.minelittlepony.common.client.gui.element.Selector;
import com.minelittlepony.common.client.gui.sprite.ISprite;
import com.minelittlepony.common.client.gui.sprite.ItemStackSprite;
import com.minelittlepony.common.client.gui.sprite.TextureSprite;
import com.minelittlepony.common.client.gui.style.Style;
import com.minelittlepony.hdskins.client.HDSkins;
import com.minelittlepony.hdskins.client.gui.DualCarouselWidget;
import com.minelittlepony.hdskins.client.gui.PlayerBodyWidget;
import com.minelittlepony.hdskins.client.gui.SettingsScreen;
import com.minelittlepony.hdskins.client.gui.SkinChooser;
import com.minelittlepony.hdskins.client.gui.SkinUploader;
import com.minelittlepony.hdskins.client.gui.StatusBanner;
import com.minelittlepony.hdskins.client.gui.filesystem.FileDrop;
import com.minelittlepony.hdskins.client.gui.player.skins.PlayerSkins;
import com.minelittlepony.hdskins.client.resources.EquipmentList;
import com.minelittlepony.hdskins.profile.SkinType;
import com.minelittlepony.hdskins.server.Feature;
import com.minelittlepony.hdskins.server.SkinServerList;
import com.minelittlepony.hdskins.server.SkinUpload;
import java.io.IOException;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import net.minecraft.class_10055;
import net.minecraft.class_10537;
import net.minecraft.class_1074;
import net.minecraft.class_11405;
import net.minecraft.class_11905;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_751;
import net.minecraft.class_766;
import org.jetbrains.annotations.Nullable;

public class GuiSkins
extends GameGui {
    public static final class_2960 WIDGETS_TEXTURE = HDSkins.id("textures/gui/widgets.png");
    public static final class_2960 PANORAMA_TEXTURE = HDSkins.id("textures/cubemaps/panorama");
    public static final class_2561 HD_SKINS_TITLE = class_2561.method_43471((String)"hdskins.gui.title");
    public static final class_2561 HD_SKINS_OPTION_DISABLED_DESC = class_2561.method_43471((String)"hdskins.warning.disabled.description");
    private static BiFunction<class_437, SkinServerList, GuiSkins> skinsGuiFunc = GuiSkins::new;
    private final class_2960 background = this.getBackground();
    private final class_751 cubemap = new class_751(this.background);
    private final class_766 panorama = new class_766(this.cubemap);
    protected final DualCarouselWidget<?> previewer;
    protected final SkinUploader uploader;
    protected final SkinChooser chooser;
    private final StatusBanner banner;
    private final FileDrop dropper;
    private final SkinUpload.Session session = new SkinUpload.Session(class_310.method_1551().method_53462(), class_310.method_1551().method_1548().method_1674(), SkinUpload.Session.validator((session, serverId) -> this.field_22787.method_73361().comp_837().joinServer(session.profile().id(), session.accessToken(), serverId)));
    @Nullable
    private Selector<SkinType> typeSelector;

    public static void setSkinsGui(BiFunction<class_437, SkinServerList, GuiSkins> skinsGuiFunc) {
        Preconditions.checkNotNull(skinsGuiFunc, (Object)"skinsGuiFunc");
        GuiSkins.skinsGuiFunc = skinsGuiFunc;
    }

    public static GuiSkins create(class_437 parent, SkinServerList servers) {
        return skinsGuiFunc.apply(parent, servers);
    }

    public static TextureSprite createIcon(int u, int v) {
        return new TextureSprite().setTexture(WIDGETS_TEXTURE).setPosition(2, 2).setSize(16, 16).setTextureOffset(u, v);
    }

    public static Tooltip createFeatureTooltip(Tooltip originalTooltip, BooleanSupplier isEnabled) {
        Tooltip disabledTooltip = Tooltip.of((class_2561)class_2561.method_43469((String)"hdskins.warning.disabled.title", (Object[])new Object[]{originalTooltip.getString(), HD_SKINS_OPTION_DISABLED_DESC}));
        return () -> !isEnabled.getAsBoolean() ? disabledTooltip.getLines() : originalTooltip.getLines();
    }

    public GuiSkins(class_437 parent, SkinServerList servers) {
        super(HD_SKINS_TITLE, parent);
        this.field_22787 = class_310.method_1551();
        this.previewer = this.createPreviewer();
        this.chooser = new SkinChooser(this.previewer);
        this.uploader = new SkinUploader(servers.getCycler(), this.previewer, this.session);
        this.banner = new StatusBanner(this.uploader);
        this.dropper = FileDrop.newDropEvent(paths -> paths.stream().findFirst().ifPresent(this.chooser::selectFile));
        this.uploader.addSkinTypeChangedEventListener(type -> GuiSkins.playSound((class_3414)class_3417.field_14978));
        this.uploader.addSkinLoadedEventListener((type, location, profileTexture) -> {
            GuiSkins.playSound((class_3414)class_3417.field_14815);
            if (this.typeSelector != null) {
                this.typeSelector.setValue((Object)this.previewer.getActiveSkinType());
            }
        });
        this.field_22787.method_1531().method_65876(this.background, (class_10537)new class_11405(this.background));
    }

    protected DualCarouselWidget<?> createPreviewer() {
        return new DualCarouselWidget<class_10055>(this, this){

            @Override
            protected PlayerBodyWidget<class_10055> createEntity(PlayerSkins<?> skins) {
                return new PlayerBodyWidget<class_10055>(skins, new class_10055());
            }
        };
    }

    protected class_2960 getBackground() {
        return PANORAMA_TEXTURE;
    }

    public void method_25393() {
        this.previewer.update();
        this.chooser.update();
        this.uploader.update();
    }

    public void method_25426() {
        this.previewer.init();
        ((Label)this.addButton((class_364)new Label(this.field_22789 / 2, 5))).setCentered().getStyle().setText("hdskins.manager").setColor(0xFFFFFF);
        int typeSelectorWidth = Math.max(this.previewer.local.bounds.width, 200);
        ((Selector)this.addButton((class_364)new Selector((this.field_22789 - typeSelectorWidth) / 2, this.previewer.local.bounds.top - 25, typeSelectorWidth, 20, (Object)SkinType.SKIN, type -> {
            if (type.isUnsupported()) {
                return new Style().setIcon((ISprite)new TextureSprite().setTexture(SkinType.UNKNOWN.icon()).setPosition(2, 2).setSize(16, 16).setTextureSize(16, 16)).setText((class_2561)class_2561.method_43469((String)"skin_type.hdskins.unknown", (Object[])new Object[]{type.getId().toString()})).setTooltip(type.getId().toString(), 0, 10);
            }
            return new Style().setIcon((ISprite)(class_310.method_1551().method_1478().method_14486(type.icon()).isEmpty() ? new ItemStackSprite().setStack(type.iconStack()) : new TextureSprite().setTexture(type.icon()).setPosition(2, 2).setSize(16, 16).setTextureSize(16, 16))).setText((class_2561)class_2561.method_43469((String)"hdskins.skin_type", (Object[])new Object[]{class_2561.method_43471((String)class_156.method_646((String)"skin_type", (class_2960)type.getId()))})).setTooltip(type.getId().toString(), 0, 10);
        }))).setValue((Object)this.previewer.getActiveSkinType()).onChange(type -> {
            List<SkinType> types = this.uploader.getSupportedSkinTypes().toList();
            int index = types.indexOf(type);
            type = index < 0 ? SkinType.SKIN : types.get((index + 1) % types.size());
            this.uploader.setSkinType((SkinType)type);
            this.uploader.scheduleReload();
            return type;
        }).onUpdate(sender -> sender.setEnabled(this.uploader.getFeatures().contains((Object)Feature.MODEL_TYPES)));
        ((Button)this.addButton((class_364)new Button(this.field_22789 / 2 - 10, this.field_22790 / 2 - 20, 20, 40))).onUpdate(sender -> sender.setEnabled(this.uploader.canUpload(this.previewer.getActiveSkinType()) && this.chooser.hasSelection())).setEnabled(this.uploader.canUpload(this.previewer.getActiveSkinType()) && this.chooser.hasSelection()).onClick(sender -> {
            if (this.uploader.canUpload(this.previewer.getActiveSkinType()) && this.chooser.hasSelection()) {
                this.uploader.uploadSkin(StatusBanner.HD_SKINS_UPLOAD, SkinUpload.create(this.chooser.getSelection(), this.previewer.getActiveSkinType(), this.uploader.getMetadata(), this.session));
            }
        }).getStyle().setIcon((ISprite)new TextureSprite().setTexture(WIDGETS_TEXTURE).setPosition(2, 11).setSize(16, 16).setTextureOffset(16, 48)).setTooltip(GuiSkins.createFeatureTooltip(Tooltip.of((String)"hdskins.options.chevy.title"), () -> this.uploader.getFeatures().contains((Object)Feature.UPLOAD_USER_SKIN)));
        this.initLocalPreviewButtons(this.previewer.local.bounds);
        this.initServerPreviewButtons(this.previewer.remote.bounds);
        ((Button)this.addButton((class_364)new Button(this.field_22789 / 2 - 25, this.previewer.remote.bounds.bottom() + 10, 50, 20))).onClick(sender -> this.finish()).getStyle().setText("hdskins.options.close");
    }

    protected void initLocalPreviewButtons(Bounds area) {
        area = ((Button)((Button)this.addButton((class_364)new Button(area.left, area.bottom() + 5, 50, 20))).onUpdate(sender -> sender.setEnabled(!this.chooser.pickingInProgress())).onClick(sender -> this.chooser.openBrowsePNG(class_1074.method_4662((String)"hdskins.open.title", (Object[])new Object[0]))).styled(s -> s.setText("hdskins.options.browse"))).getBounds();
        area = ((Selector)this.addButton((class_364)new Selector(area.right() + 5, area.top, 20, 20, (Object)HDSkins.getInstance().getDummyPlayerEquipmentList().getDefault(), equipment -> new Style().setIcon(equipment.getStack()).setTooltip(equipment.getTooltip(), 0, 10)))).setValue((Object)this.previewer.getEquipment()).onChange(value -> {
            List<EquipmentList.EquipmentSet> equipments = HDSkins.getInstance().getDummyPlayerEquipmentList().getValues().toList();
            int index = equipments.indexOf(value);
            value = index < 0 ? value : equipments.get((index + 1) % equipments.size());
            this.previewer.setEquipment((EquipmentList.EquipmentSet)value);
            GameGui.playSound((class_3414)value.getSound());
            return value;
        }).getBounds();
        area = ((Selector)this.addButton((class_364)new Selector(area.right() + 5, area.top, 20, 20, (Object)PlayerSkins.Posture.SkinVariant.DEFAULT, variant -> new Style().setIcon(variant.icon()).setTooltip(GuiSkins.createFeatureTooltip(Tooltip.of((class_2561)variant.tooltip()), () -> this.uploader.getFeatures().contains((Object)Feature.MODEL_VARIANTS))).setTooltipOffset(0, 10)))).setValue((Object)this.previewer.getSkinVariant().orElse(PlayerSkins.Posture.SkinVariant.DEFAULT)).onChange(variant -> {
            List<PlayerSkins.Posture.SkinVariant> variants = this.previewer.getSkinVariants();
            int index = variants.indexOf(variant);
            variant = index < 0 ? variant : variants.get((index + 1) % variants.size());
            GuiSkins.playSound((class_3414)class_3417.field_14978);
            this.uploader.setMetadataField("model", variant.name());
            this.previewer.setSkinVariant((PlayerSkins.Posture.SkinVariant)variant);
            return variant;
        }).onUpdate(sender -> sender.setEnabled(this.uploader.getFeatures().contains((Object)Feature.MODEL_VARIANTS))).getBounds();
        ((Cycler)this.addButton((class_364)new Cycler(area.right() + 5, area.top, 20, 20))).setStyles(PlayerSkins.Posture.Pose.STYLES).setValue(Integer.valueOf(this.previewer.getPose().ordinal())).onChange(i -> {
            GuiSkins.playSound((class_3414)class_3417.field_14978);
            this.previewer.setPose(PlayerSkins.Posture.Pose.VALUES[i % PlayerSkins.Posture.Pose.VALUES.length]);
            return i;
        });
    }

    protected void initServerPreviewButtons(Bounds area) {
        area = ((Button)((Button)this.addButton((class_364)new Button(area.right() - 16, area.bottom() + 5, 16, 20))).onClick(sender -> {
            this.uploader.cycleGateway();
            GuiSkins.playSound((class_3414)class_3417.field_14815);
            sender.getStyle().setTooltip(this.uploader.getGatewayText());
        }).styled(s -> s.setIcon((ISprite)GuiSkins.createIcon(81, 16)).setTooltip(Tooltip.of((String)this.uploader.getGatewayText(), (int)400)).setTooltipOffset(0, 10))).getBounds();
        area = ((Button)((Button)this.addButton((class_364)new Button(area.left - 19, area.top, 20, 20))).onClick(sender -> this.field_22787.method_1507((class_437)new SettingsScreen((class_437)this, this.panorama))).styled(s -> s.setIcon((ISprite)GuiSkins.createIcon(80, 0)).setTooltip("options.title", 0, 10))).getBounds();
        area = ((Button)((Button)this.addButton((class_364)new Button(area.left - 25, area.top, 20, 20))).onUpdate(sender -> sender.setEnabled(this.uploader.canClearAny())).onClick(sender -> SkinType.REGISTRY.forEach(type -> this.uploader.uploadSkin(StatusBanner.HD_SKINS_REQUEST, SkinUpload.delete(this.previewer.getActiveSkinType(), this.session)))).styled(s -> s.setIcon((ISprite)GuiSkins.createIcon(48, 16)).setTooltip(GuiSkins.createFeatureTooltip(Tooltip.of((String)"hdskins.options.clear_all"), () -> this.uploader.getFeatures().contains((Object)Feature.DELETE_USER_SKIN))))).getBounds();
        area = ((Button)((Button)this.addButton((class_364)new Button(area.left - 25, area.top, 20, 20))).onUpdate(sender -> sender.setEnabled(this.uploader.canClear(this.previewer.getActiveSkinType()))).onClick(sender -> {
            if (this.uploader.canClear(this.previewer.getActiveSkinType())) {
                this.uploader.uploadSkin(StatusBanner.HD_SKINS_REQUEST, SkinUpload.delete(this.previewer.getActiveSkinType(), this.session));
            }
        }).styled(s -> s.setIcon((ISprite)GuiSkins.createIcon(48, 0)).setTooltip(GuiSkins.createFeatureTooltip(Tooltip.of((String)"hdskins.options.clear"), () -> this.uploader.getFeatures().contains((Object)Feature.DELETE_USER_SKIN))))).getBounds();
        ((Button)this.addButton((class_364)new Button(area.left - 25, area.top, 20, 20))).onUpdate(sender -> sender.setEnabled(this.uploader.getFeatures().contains((Object)Feature.DOWNLOAD_USER_SKIN) && this.uploader.hasUploaded(this.previewer.getActiveSkinType()) && !this.chooser.pickingInProgress())).onClick(sender -> {
            if (this.uploader.hasUploaded(this.previewer.getActiveSkinType())) {
                this.chooser.openSavePNG(this.uploader, class_1074.method_4662((String)"hdskins.save.title", (Object[])new Object[0]), this.field_22787.method_1548().method_1676());
            }
        }).getStyle().setIcon((ISprite)GuiSkins.createIcon(0, 0)).setTooltip(GuiSkins.createFeatureTooltip(Tooltip.of((String)"hdskins.options.download.title"), () -> this.uploader.getFeatures().contains((Object)Feature.DOWNLOAD_USER_SKIN)));
    }

    public void method_25432() {
        this.dropper.cancel();
    }

    public void method_25419() {
        super.method_25419();
        try {
            this.uploader.close();
        }
        catch (IOException e) {
            HDSkins.LOGGER.error("Could not dispose of the uploader", (Throwable)e);
        }
        HDSkins.getInstance().getProfileRepository().clear();
    }

    public void method_49589() {
        this.dropper.subscribe();
        this.uploader.scheduleReload();
    }

    protected boolean canTakeEvents() {
        return !this.chooser.pickingInProgress() && this.uploader.tryClearStatus() && !this.banner.isVisible();
    }

    public boolean method_25402(class_11909 click, boolean doubled) {
        return this.canTakeEvents() && !super.method_25402(click, doubled) && this.previewer.mouseClicked(this.uploader, this.field_22789, this.field_22790, click);
    }

    public boolean method_25403(class_11909 click, double changeX, double changeY) {
        return this.canTakeEvents() && this.previewer.mouseDragged(click, changeX, changeY) && super.method_25403(click, changeX, changeY);
    }

    public boolean method_25404(class_11908 input) {
        if (input.method_74238() && input.method_74240() && input.method_74228() == 82) {
            this.field_22787.method_1521();
            return true;
        }
        return !input.method_74229() && super.method_25404(input);
    }

    public boolean method_25400(class_11905 input) {
        return this.canTakeEvents() && !this.chooser.pickingInProgress() && !this.uploader.isBusy() && super.method_25400(input);
    }

    public void method_25420(class_332 context, int mouseX, int mouseY, float tickDelta) {
        super.method_25420(context, mouseX, mouseY, tickDelta);
        this.previewer.render(context, mouseX, mouseY, tickDelta, this.chooser, this.uploader);
    }

    protected void method_57728(class_332 context, float tickDelta) {
        this.panorama.method_3317(context, this.field_22789, this.field_22790, true);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float tickDelta) {
        super.method_25394(context, mouseX, mouseY, tickDelta);
        this.banner.render(context, tickDelta, this.field_22789, this.field_22790);
    }
}

