/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.hdskins.client.gui;

import com.minelittlepony.common.client.gui.GameGui;
import com.minelittlepony.common.client.gui.dimension.Bounds;
import com.minelittlepony.common.client.gui.element.Button;
import com.minelittlepony.hdskins.client.gui.Carousel;
import com.minelittlepony.hdskins.client.gui.DualCarouselWidget;
import com.minelittlepony.hdskins.client.gui.GuiSkins;
import com.minelittlepony.hdskins.client.gui.PlayerBodyWidget;
import com.minelittlepony.hdskins.client.gui.SkinUploader;
import com.minelittlepony.hdskins.client.gui.player.skins.PreviousServerPlayerSkins;
import com.minelittlepony.hdskins.client.gui.player.skins.ServerPlayerSkins;
import com.minelittlepony.hdskins.profile.SkinType;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import net.minecraft.class_10055;
import net.minecraft.class_10799;
import net.minecraft.class_11909;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_6880;
import org.joml.Matrix3x2fStack;
import org.joml.Quaternionf;

public class SkinListWidget<S extends class_10055>
implements Carousel.Element {
    private final DualCarouselWidget<S> previewer;
    private final class_310 client = class_310.method_1551();
    private final Bounds containerBounds;
    private final Bounds bounds = new Bounds(0, 0, 0, 32);
    private float prevScrollPosition;
    private float scrollPosition;
    private int targetScrollPosition;
    private Button scrollLeft;
    private Button scrollRight;
    private final Int2ObjectMap<PlayerBodyWidget<S>> modelStates = new Int2ObjectOpenHashMap();

    public SkinListWidget(DualCarouselWidget<S> previewer, Bounds bounds) {
        this.previewer = previewer;
        this.containerBounds = bounds;
    }

    public void init(GuiSkins screen) {
        this.bounds.width = this.containerBounds.width - 20;
        this.bounds.left = this.containerBounds.left + 10;
        this.bounds.top = this.containerBounds.top + this.containerBounds.height - this.bounds.height;
        this.scrollLeft = new Button(this.bounds.left - 10, this.bounds.top, 10, this.bounds.height);
        ((Button)screen.addButton((class_364)this.scrollLeft)).onClick(sender -> this.scrollBy(-1)).getStyle().setText("<");
        this.scrollRight = new Button(this.bounds.left + this.bounds.width, this.bounds.top, 10, this.bounds.height);
        ((Button)screen.addButton((class_364)this.scrollRight)).onClick(sender -> this.scrollBy(1)).getStyle().setText(">");
        this.updateButtons();
    }

    private void scrollBy(int steps) {
        int pageSize;
        this.targetScrollPosition += steps;
        int skins = this.previewer.getRemote().getSkins().getProfileSkins(this.previewer.getActiveSkinType()).size();
        this.targetScrollPosition = skins < (pageSize = this.bounds.width / this.bounds.height) ? 0 : class_3532.method_15340((int)this.targetScrollPosition, (int)0, (int)skins);
    }

    private float getScrollOffset() {
        return -class_3532.method_16439((float)class_310.method_1551().method_61966().method_60637(false), (float)this.prevScrollPosition, (float)this.scrollPosition) * (float)this.bounds.height;
    }

    private void updateButtons() {
        List<PreviousServerPlayerSkins> skins = this.previewer.getRemote().getSkins().getProfileSkins(this.previewer.getActiveSkinType());
        boolean hasContent = !skins.isEmpty();
        int pageSize = this.bounds.width / this.bounds.height;
        if (this.scrollPosition > (float)Math.max(skins.size() - 1, 0)) {
            this.targetScrollPosition = 0;
        }
        this.scrollLeft.setVisible(hasContent);
        this.scrollLeft.setEnabled(hasContent && this.scrollPosition > 0.0f);
        this.scrollRight.setVisible(hasContent);
        this.scrollRight.setEnabled(hasContent && skins.size() >= pageSize && (float)(skins.size() - pageSize - 1) > this.scrollPosition);
    }

    @Override
    public void tick() {
        List<PreviousServerPlayerSkins> skins = this.previewer.getRemote().getSkins().getProfileSkins(this.previewer.getActiveSkinType());
        if (skins.isEmpty()) {
            this.modelStates.clear();
            return;
        }
        this.modelStates.int2ObjectEntrySet().removeIf(e -> e.getIntKey() >= skins.size());
        this.modelStates.values().forEach(Carousel.Element::tick);
    }

    @Override
    public void updateState(float xPosition, float yPosition, float mouseX, float mouseY, float tickDelta) {
        this.prevScrollPosition = this.scrollPosition;
        if ((float)this.targetScrollPosition != this.scrollPosition) {
            if (this.scrollPosition > (float)this.targetScrollPosition) {
                this.scrollPosition = this.scrollPosition - (float)this.targetScrollPosition < 0.2f ? (float)this.targetScrollPosition : (this.scrollPosition -= 0.1f);
            }
            if (this.scrollPosition < (float)this.targetScrollPosition) {
                this.scrollPosition = (float)this.targetScrollPosition - this.scrollPosition < 0.2f ? (float)this.targetScrollPosition : (this.scrollPosition += 0.1f);
            }
        }
        this.updateButtons();
        List<PreviousServerPlayerSkins> skins = this.previewer.getRemote().getSkins().getProfileSkins(this.previewer.getActiveSkinType());
        int frameWidth = this.bounds.height;
        int index = (int)(mouseX - ((float)this.bounds.left + this.getScrollOffset())) / frameWidth;
        boolean hovered = this.bounds.contains((double)mouseX, (double)mouseY);
        for (int i = 0; i < skins.size(); ++i) {
            if (skins.get(i).getType().isUnsupported()) continue;
            PlayerBodyWidget<S> player = this.getOrCreateStateAt(i, skins.get(i));
            player.updateState(xPosition, yPosition, mouseX, mouseY, tickDelta);
            ((class_10055)player.playerState).field_53450 = 0.0f;
            if (!hovered || i != index) continue;
            ((class_10055)player.playerState).field_53450 = 0.5f;
            player.position.y -= 3.0f;
        }
    }

    @Override
    public void render(class_332 context, Bounds outerFrameBounds, int mouseX, int mouseY, Quaternionf rotation) {
        List<PreviousServerPlayerSkins> skins = this.previewer.getRemote().getSkins().getProfileSkins(this.previewer.getActiveSkinType());
        if (skins.isEmpty()) {
            return;
        }
        int frameWidth = this.bounds.height;
        Matrix3x2fStack matrices = context.method_51448();
        matrices.pushMatrix();
        this.bounds.translate(matrices);
        context.method_25294(0, frameWidth, this.bounds.width, 0, -1610612736);
        int index = (int)((float)mouseX - ((float)this.bounds.left + this.getScrollOffset())) / frameWidth;
        boolean hovered = this.bounds.contains((double)mouseX, (double)mouseY);
        matrices.translate(this.getScrollOffset(), 0.0f);
        if (hovered && index < skins.size()) {
            context.method_25294(index * frameWidth, 0, (index + 1) * frameWidth, frameWidth, -1599427926);
        }
        for (int i = 0; i < skins.size(); ++i) {
            PreviousServerPlayerSkins skin = skins.get(i);
            context.method_25294(i * frameWidth, 0, (i + 1) * frameWidth, frameWidth, -1610612736);
            if (this.previewer.getActiveSkinType() == skin.getType()) {
                if (skin.getType().isUnsupported()) {
                    context.method_25290(class_10799.field_56883, ((ServerPlayerSkins.RemoteTexture)skin.get(skin.getType())).getId(), i * frameWidth, 0, 0.0f, 0.0f, frameWidth, frameWidth, 64, 64);
                } else {
                    this.bounds.left = outerFrameBounds.left + 10 + (int)this.getScrollOffset() + i * frameWidth;
                    this.bounds.width = frameWidth;
                    this.getOrCreateStateAt(i, skin).render(context, this.bounds, mouseX, mouseY, rotation);
                }
            }
            if (!skin.getSkin().isActive()) continue;
            context.method_25294(i * frameWidth, 1, i * frameWidth + 1, frameWidth, -1);
            context.method_25294((i + 1) * frameWidth, 1, (i + 1) * frameWidth - 1, frameWidth, -1);
            context.method_25294(i * frameWidth, frameWidth - 1, (i + 1) * frameWidth, frameWidth, -1);
            context.method_25294(i * frameWidth, 0, (i + 1) * frameWidth, 1, -1);
        }
        this.bounds.left = outerFrameBounds.left + 10;
        this.bounds.width = outerFrameBounds.width - 20;
        matrices.popMatrix();
    }

    private PlayerBodyWidget<S> getOrCreateStateAt(int index, PreviousServerPlayerSkins skin) {
        return (PlayerBodyWidget)this.modelStates.compute(index, (i, state) -> {
            if (state == null) {
                state = this.previewer.createEntity(skin);
            }
            state.skins = skin;
            return state;
        });
    }

    public boolean mouseClicked(SkinUploader uploader, class_11909 click) {
        if (click.method_74245() != 0) {
            return false;
        }
        int frameWidth = this.bounds.height;
        if (!this.bounds.contains(click.comp_4798(), click.comp_4799())) {
            return false;
        }
        int index = (int)((click.comp_4798() - (double)((float)this.bounds.left + this.getScrollOffset())) / (double)frameWidth);
        if (index >= this.previewer.getRemote().getSkins().getProfileSkins(this.previewer.getActiveSkinType()).size()) {
            return false;
        }
        GameGui.playSound((class_6880.class_6883)class_3417.field_15015);
        return uploader.getGateway().filter(gateway -> gateway.getProfile(uploader.getSession()).getNow(Optional.empty()).filter(profile -> {
            SkinType type = this.previewer.getActiveSkinType();
            if (index >= 0 && index <= profile.getSkins(type).size()) {
                gateway.swapSkin(profile, type, index, uploader::setBannerMessage).thenRunAsync(uploader::scheduleReload, (Executor)this.client);
                return true;
            }
            return false;
        }).isPresent()).isPresent();
    }
}

