/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.hdskins.client.gui.filesystem;

import com.minelittlepony.hdskins.client.HDSkins;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Locale;
import net.minecraft.class_156;
import org.spongepowered.include.com.google.common.base.Strings;

public interface FileSystemUtil {
    public static final boolean IS_LINUX = class_156.method_668() == class_156.class_158.field_1135;
    public static final boolean IS_SANDBOXED = FileSystemUtil.isSandboxed();
    public static final String CONTENT_TYPE_DOWNLOAD = "Download";

    public static boolean isSandboxed() {
        return !Strings.nullToEmpty((String)System.getenv("FLATPAK_ID")).isEmpty() && !Strings.nullToEmpty((String)System.getenv("FLATPAK_SANDBOX_DIR")).isEmpty();
    }

    public static Path getActiveDirectory() {
        return Path.of("/", new String[0]);
    }

    public static Path getUserDirectory() {
        String path = Strings.nullToEmpty((String)System.getProperty("user.home"));
        if (path.isEmpty()) {
            return FileSystemUtil.getActiveDirectory();
        }
        try {
            return Path.of(path, new String[0]);
        }
        catch (Exception e) {
            HDSkins.LOGGER.error((Object)e);
            return FileSystemUtil.getActiveDirectory();
        }
    }

    public static Path getUserContentDirectory(String contentType) {
        Path userDirectory = FileSystemUtil.getUserDirectory();
        if (userDirectory.getParent() == null) {
            return userDirectory;
        }
        do {
            Path candidate;
            if (Files.isDirectory(candidate = userDirectory.resolve((String)contentType), new LinkOption[0])) {
                return candidate;
            }
            candidate = userDirectory.resolve(((String)contentType).toLowerCase(Locale.ROOT));
            if (!Files.isDirectory(candidate, new LinkOption[0])) continue;
            return candidate;
        } while (!((String)(contentType = (String)contentType + "s")).endsWith("ss"));
        return userDirectory;
    }
}

