/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.hdskins.client.gui.filesystem.integrated;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.minelittlepony.common.client.gui.GameGui;
import com.minelittlepony.common.client.gui.ScrollContainer;
import com.minelittlepony.common.client.gui.element.Button;
import com.minelittlepony.common.client.gui.element.Label;
import com.minelittlepony.common.client.gui.packing.GridPacker;
import com.minelittlepony.common.client.gui.sprite.ISprite;
import com.minelittlepony.common.client.gui.sprite.TextureSprite;
import com.minelittlepony.hdskins.client.HDConfig;
import com.minelittlepony.hdskins.client.HDSkins;
import com.minelittlepony.hdskins.client.gui.filesystem.FileDialog;
import com.minelittlepony.hdskins.client.gui.filesystem.FileSystemUtil;
import com.minelittlepony.hdskins.util.net.FileTypes;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public class FileSelectorScreen
extends GameGui
implements FileDialog {
    private static final class_2960 ICONS = HDSkins.id("textures/gui/files.png");
    private static final TextureSprite FOLDER = new TextureSprite();
    private static final TextureSprite FILE = new TextureSprite().setTextureOffset(0, 14);
    private static final TextureSprite IMAGE = new TextureSprite().setTextureOffset(14, 0);
    private static final TextureSprite AUDIO = new TextureSprite().setTextureOffset(14, 14);
    private static final TextureSprite VIDEO = new TextureSprite().setTextureOffset(28, 14);
    protected Path currentDirectory;
    private FileDialog.Callback callback = (f, b) -> {};
    private final GridPacker packer = new GridPacker().setItemWidth(150).setItemHeight(20);
    protected Button parentBtn;
    protected class_342 textInput;
    protected final ScrollContainer filesList = new ScrollContainer();
    protected String extensionFilter = "";
    private String filterMessage = "";

    public FileSelectorScreen(String title) {
        super((class_2561)class_2561.method_43470((String)title));
        this.filesList.margin.top = 60;
        this.filesList.margin.bottom = 30;
        this.filesList.getContentPadding().setAll(10);
        this.currentDirectory = (Path)HDSkins.getInstance().getConfig().lastChosenFile.get();
        if (!Files.exists(this.currentDirectory, new LinkOption[0])) {
            this.currentDirectory = FileSystemUtil.getUserContentDirectory("Download");
        }
    }

    protected void method_25426() {
        this.getChildElements().add(this.filesList);
        this.renderDirectory();
        this.textInput = new class_342(this.getFont(), 10, 30, this.field_22789 - 50, 18, class_5244.field_39003);
        this.addButton((class_364)this.textInput);
        this.textInput.method_1888(true);
        this.textInput.method_1880(Integer.MAX_VALUE);
        this.textInput.method_1852(this.currentDirectory.toAbsolutePath().toString());
        ((Button)this.addButton((class_364)new Button(this.field_22789 - 30, 29, 20, 20))).onClick(p -> this.navigateTo(Paths.get(this.textInput.method_1882(), new String[0]))).getStyle().setText("hdskins.directory.go");
        ((Label)this.addButton((class_364)new Label(this.field_22789 / 2, 5).setCentered())).getStyle().setText(this.method_25440().getString());
        this.parentBtn = new Button(this.field_22789 / 2 - 160, this.field_22790 - 25, 100, 20);
        ((Button)this.addButton((class_364)this.parentBtn)).onClick(p -> this.navigateTo(this.currentDirectory.getParent())).setEnabled(this.canNavigateUp()).getStyle().setText("hdskins.directory.up");
        ((Button)this.addButton((class_364)new Button(this.field_22789 / 2 + 60, this.field_22790 - 25, 100, 20))).onClick(p -> this.finish()).getStyle().setText("hdskins.options.close");
        if (!this.filterMessage.isEmpty()) {
            this.filesList.margin.bottom = 60;
            ((Label)this.addButton((class_364)new Label(10, this.field_22790 - 55))).getStyle().setColor(-1997607186).setText("* " + this.filterMessage);
        }
    }

    public void finish() {
        super.finish();
        this.callback.onDialogClosed(this.currentDirectory, false);
    }

    public boolean method_25422() {
        return false;
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float tickDelta) {
        super.method_25394(context, mouseX, mouseY, tickDelta);
        this.filesList.method_25394(context, mouseX, mouseY, tickDelta);
    }

    protected void renderDirectory() {
        this.filesList.init(() -> {
            int buttonX = this.filesList.field_22789 / 2 - 110;
            this.listFiles().forEach(path -> {
                int buttonY = this.filesList.buttons().size() * 20;
                this.filesList.addButton((class_364)new PathButton(buttonX, buttonY, 150, 20, (Path)path));
            });
            this.packer.setListWidth(this.field_22789).pack((class_437)this.filesList);
        });
    }

    protected Stream<Path> listFiles() {
        Path directory = this.currentDirectory;
        if (!Files.isDirectory(directory, new LinkOption[0])) {
            directory = directory.getParent();
        }
        if (directory == null) {
            directory = FileSystemUtil.getUserContentDirectory("Download");
        }
        try {
            return Files.list(directory).filter(this::filterPath);
        }
        catch (IOException iOException) {
            return Stream.empty();
        }
    }

    protected boolean filterPath(@Nullable Path path) {
        try {
            if (path == null || Files.isHidden(path)) {
                return false;
            }
        }
        catch (IOException e) {
            return false;
        }
        return this.extensionFilter.isEmpty() || Files.isDirectory(path, new LinkOption[0]) || path.getFileName().toString().endsWith(this.extensionFilter);
    }

    public void navigateTo(Path path) {
        if (path == null) {
            return;
        }
        if (Files.isDirectory(path = path.toAbsolutePath(), new LinkOption[0])) {
            this.onDirectorySelected(path);
        } else {
            this.onFileSelected(path);
        }
    }

    protected void onDirectorySelected(Path path) {
        this.textInput.method_1852(path.toString());
        this.currentDirectory = path;
        HDConfig config = HDSkins.getInstance().getConfig();
        config.lastChosenFile.set((Object)path);
        config.save();
        this.parentBtn.setEnabled(this.canNavigateUp());
        this.renderDirectory();
    }

    protected boolean canNavigateUp() {
        return this.currentDirectory.getParent() != null && (Files.isDirectory(this.currentDirectory, new LinkOption[0]) || this.currentDirectory.getParent().getParent() != null);
    }

    protected void onFileSelected(Path fileLocation) {
        HDConfig config = HDSkins.getInstance().getConfig();
        config.lastChosenFile.set((Object)fileLocation);
        config.save();
        this.field_22787.method_1507(this.parent);
        this.callback.onDialogClosed(fileLocation, true);
    }

    protected void onPathSelected(PathButton sender) {
        this.navigateTo(sender.path);
    }

    protected TextureSprite getIcon(Path path) {
        if (Files.isDirectory(path, new LinkOption[0])) {
            return FOLDER;
        }
        String mime = FileTypes.getMimeType(path);
        if (mime.contains("image")) {
            return IMAGE;
        }
        if (mime.contains("audio")) {
            return AUDIO;
        }
        if (mime.contains("video")) {
            return VIDEO;
        }
        return FILE;
    }

    @Override
    public FileDialog startIn(Path currentDirectory) {
        this.currentDirectory = currentDirectory;
        return this;
    }

    @Override
    public FileDialog filter(String extension, String description) {
        this.extensionFilter = Strings.nullToEmpty((String)extension);
        this.filterMessage = Strings.nullToEmpty((String)description);
        this.filesList.margin.bottom = !this.filterMessage.isEmpty() ? 60 : 30;
        return this;
    }

    @Override
    public FileDialog andThen(FileDialog.Callback callback) {
        this.callback = callback;
        return this;
    }

    @Override
    public FileDialog launch() {
        class_310.method_1551().method_1507((class_437)this);
        return this;
    }

    class PathButton
    extends Button {
        protected final Path path;

        public PathButton(int x, int y, int width, int height, Path path) {
            super(x, y, width, height);
            this.path = path;
            class_5250 name = class_2561.method_43470((String)path.getFileName().toString().replace('\u00a7', '?'));
            class_5250 format = this.describeFile(path);
            format.method_10862(format.method_10866().method_10977(class_124.field_1080).method_10978(Boolean.valueOf(true)));
            TextureSprite sprite = FileSelectorScreen.this.getIcon(path).setPosition(6, 6).setTexture(ICONS).setTextureSize(53, 53).setSize(13, 11);
            this.onClick(self -> FileSelectorScreen.this.onPathSelected(this));
            this.setEnabled(Files.isReadable(path));
            this.getStyle().setText(this.trimLabel(name.getString())).setIcon((ISprite)sprite).setTooltip((List)Lists.newArrayList((Object[])new class_2561[]{name, format}));
        }

        private String trimLabel(String name) {
            int maxWidth = this.field_22758 - 35;
            if (this.getFont().method_1727((String)name) > maxWidth) {
                name = this.getFont().method_27523((String)name, maxWidth - this.getFont().method_1727("...")) + "...";
            }
            return ((String)name).replace("%", "%%");
        }

        public void clearFocus() {
            this.method_25365(false);
        }

        protected class_5250 describeFile(Path path) {
            if (Files.isDirectory(path, new LinkOption[0])) {
                return class_2561.method_43471((String)"hdskins.filetype.directory");
            }
            String extension = FileTypes.getExtension(path);
            if (extension.isEmpty()) {
                return class_2561.method_43471((String)"hdskins.filetype.unknown");
            }
            return class_2561.method_43469((String)"hdskins.filetype.file", (Object[])new Object[]{extension.toUpperCase()});
        }
    }
}

