/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.hdskins.client.profile;

import com.minelittlepony.hdskins.client.VanillaModels;
import com.minelittlepony.hdskins.profile.SkinType;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_12079;
import net.minecraft.class_2960;
import net.minecraft.class_7920;
import net.minecraft.class_8685;

public interface DynamicSkinTextures {
    public static final Function<class_8685, class_12079.class_12081> NIL = t -> null;
    public static final Map<SkinType, Function<class_8685, class_12079.class_12081>> TEXTURE_LOOKUP = Map.of(SkinType.SKIN, class_8685::comp_1626, SkinType.CAPE, class_8685::comp_1627, SkinType.ELYTRA, class_8685::comp_1628);

    public Set<class_2960> getProvidedSkinTypes();

    public Optional<class_12079.class_12081> getSkin(SkinType var1);

    default public class_12079.class_12081 getSkin(SkinType type, DynamicSkinTextures fallback) {
        return this.getSkin(type).orElseGet(() -> fallback.getSkin(type).orElse(null));
    }

    public Optional<String> getModel();

    public boolean hasChanged();

    public static class_8685 toSkinTextures(DynamicSkinTextures dynamic) {
        return new class_8685((class_12079.class_12081)dynamic.getSkin(SkinType.SKIN).orElse(null), (class_12079.class_12081)dynamic.getSkin(SkinType.CAPE).orElse(null), (class_12079.class_12081)dynamic.getSkin(SkinType.ELYTRA).orElse(null), VanillaModels.isSlim(dynamic.getModel().orElse("default")) ? class_7920.field_41122 : class_7920.field_41123, false);
    }

    public static DynamicSkinTextures of(final Supplier<class_8685> supplier) {
        return new DynamicSkinTextures(){

            @Override
            public Set<class_2960> getProvidedSkinTypes() {
                return TEXTURE_LOOKUP.keySet().stream().filter(type -> this.getSkin((SkinType)type).isEmpty()).map(SkinType::getId).collect(Collectors.toSet());
            }

            @Override
            public Optional<class_12079.class_12081> getSkin(SkinType type) {
                return Optional.ofNullable((class_12079.class_12081)TEXTURE_LOOKUP.getOrDefault(type, NIL).apply((class_8685)supplier.get()));
            }

            @Override
            public Optional<String> getModel() {
                return this.getSkin(SkinType.SKIN).isPresent() ? Optional.ofNullable(((class_8685)supplier.get()).comp_1629().name()) : Optional.empty();
            }

            @Override
            public boolean hasChanged() {
                return false;
            }
        };
    }

    default public DynamicSkinTextures union(final DynamicSkinTextures b) {
        final DynamicSkinTextures a = this;
        return new DynamicSkinTextures(){

            @Override
            public Set<class_2960> getProvidedSkinTypes() {
                return Stream.concat(a.getProvidedSkinTypes().stream(), b.getProvidedSkinTypes().stream()).distinct().collect(Collectors.toSet());
            }

            @Override
            public Optional<class_12079.class_12081> getSkin(SkinType type) {
                return Optional.ofNullable(a.getSkin(type, b));
            }

            @Override
            public Optional<String> getModel() {
                return b.getModel().or(a::getModel);
            }

            @Override
            public boolean hasChanged() {
                return a.hasChanged() || b.hasChanged();
            }
        };
    }
}

