/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.hdskins.client.profile;

import com.minelittlepony.hdskins.Memoize;
import com.minelittlepony.hdskins.client.PlayerSkins;
import com.minelittlepony.hdskins.client.ducks.ClientPlayerInfo;
import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.textures.GpuTextureView;
import net.minecraft.class_11786;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_836;
import net.minecraft.class_8538;
import net.minecraft.class_8685;
import org.jetbrains.annotations.Nullable;

public final class HDSkinCacheEntry
implements ClientPlayerInfo {
    private final class_11786.class_11787 owner;
    private final ClientPlayerInfo dynamicSkins;
    private final class_8685.class_11892 override;
    private class_8685 vanillaTextures;
    @Nullable
    private class_8685 cachedTextures;
    @Nullable
    private class_8685 textures;
    private final Memoize<class_1921> renderLayer = Memoize.basic(() -> class_836.method_72165((class_2960)this.textures.comp_1626().comp_3627()));
    private final Memoize<GpuTextureView> textureView = Memoize.basic(() -> class_310.method_1551().method_1531().method_4619(this.textures.comp_1626().comp_3627()).method_71659());
    private final Memoize<class_8538> textRenderLayers = Memoize.basic(() -> class_8538.method_51643((class_2960)this.textures.comp_1626().comp_3627()));

    public HDSkinCacheEntry(class_11786.class_11787 owner, GameProfile profile, class_8685 textures, class_8685.class_11892 override) {
        this.owner = owner;
        this.override = override;
        this.vanillaTextures = textures.method_74883(override);
        this.dynamicSkins = PlayerSkins.create(profile, () -> this.vanillaTextures);
    }

    @Override
    public PlayerSkins getSkins() {
        return this.dynamicSkins.getSkins();
    }

    public class_8685 getTextures(class_8685 vanillaTextures) {
        if (!this.vanillaTextures.equals((Object)vanillaTextures)) {
            this.vanillaTextures = vanillaTextures;
        }
        if (this.cachedTextures == null || this.getSkins().layers().hasChanged()) {
            this.cachedTextures = this.getSkins().sorted().getSkinTextures();
            this.textures = this.cachedTextures.method_74883(this.override);
            this.renderLayer.expireNow();
            this.textureView.expireNow();
            this.textRenderLayers.expireNow();
        }
        return this.textures;
    }

    private boolean checkState() {
        return this.owner.method_73503().equals((Object)this.cachedTextures) && this.cachedTextures != null;
    }

    public class_1921 getRenderLayer(class_1921 layer) {
        return this.checkState() ? (class_1921)this.renderLayer.get() : layer;
    }

    public GpuTextureView getTextureView(GpuTextureView view) {
        return this.checkState() ? (GpuTextureView)this.textureView.get() : view;
    }

    public class_8538 getTextRenderLayers(class_8538 layers) {
        return this.checkState() ? (class_8538)this.textRenderLayers.get() : layers;
    }
}

