/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.hdskins.client.resources;

import com.minelittlepony.common.event.SkinFilterCallback;
import com.minelittlepony.hdskins.client.HDSkins;
import com.minelittlepony.hdskins.client.resources.TextureLoader;
import com.minelittlepony.hdskins.profile.SkinType;
import com.minelittlepony.hdskins.util.net.URIUtil;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1011;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_4239;
import net.minecraft.class_9848;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class HDPlayerSkinTextureDownloader {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static CompletableFuture<class_2960> downloadAndRegisterTexture(class_2960 textureId, Path cacheFile, String uri, SkinType skinType) {
        return CompletableFuture.supplyAsync(() -> {
            class_1011 nativeImage;
            try {
                nativeImage = HDPlayerSkinTextureDownloader.download(cacheFile, uri);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            return SkinType.SKIN.equals(skinType) ? HDPlayerSkinTextureDownloader.remapTexture(nativeImage) : nativeImage;
        }, class_156.method_55473().method_64116("downloadTexture")).thenCompose(image -> TextureLoader.uploadTexture(textureId, image));
    }

    private static class_1011 download(Path path, String uri) throws IOException {
        if (Files.isRegularFile(path, new LinkOption[0])) {
            LOGGER.debug("Loading HTTP texture from local cache ({})", (Object)path);
            try (InputStream stream = Files.newInputStream(path, new OpenOption[0]);){
                class_1011 class_10112 = class_1011.method_4309((InputStream)stream);
                return class_10112;
            }
        }
        LOGGER.debug("Downloading HTTP texture from {} to {}", (Object)uri, (Object)path);
        byte[] response = URIUtil.getBytes(URI.create(uri));
        try {
            class_4239.method_47525((Path)path.getParent());
            Files.write(path, response, new OpenOption[0]);
        }
        catch (IOException e) {
            LOGGER.warn("Failed to cache texture {} in {}", (Object)uri, (Object)path);
        }
        return class_1011.method_49277((byte[])response);
    }

    @Nullable
    public static class_1011 remapTexture(@Nullable class_1011 image) {
        if (image == null) {
            return image;
        }
        int imageWidth = image.method_4307();
        int imageHeight = image.method_4323();
        if (!HDPlayerSkinTextureDownloader.isPowerOfTwo(imageWidth) || !HDPlayerSkinTextureDownloader.isValidShape(imageWidth, imageHeight)) {
            image.close();
            HDSkins.LOGGER.warn("Discarding incorrectly sized ({}x{}) skin texture", (Object)imageWidth, (Object)imageHeight);
            return null;
        }
        if (imageHeight != imageWidth) {
            class_1011 image2 = new class_1011(imageWidth, imageWidth, true);
            image2.method_4317(image);
            image.close();
            image = image2;
            SkinFilterCallback.fill((class_1011)image, (int)0, (int)32, (int)64, (int)32, (int)0);
            SkinFilterCallback.copy((class_1011)image, (int)4, (int)16, (int)16, (int)32, (int)4, (int)4, (boolean)true, (boolean)false);
            SkinFilterCallback.copy((class_1011)image, (int)8, (int)16, (int)16, (int)32, (int)4, (int)4, (boolean)true, (boolean)false);
            SkinFilterCallback.copy((class_1011)image, (int)0, (int)20, (int)24, (int)32, (int)4, (int)12, (boolean)true, (boolean)false);
            SkinFilterCallback.copy((class_1011)image, (int)4, (int)20, (int)16, (int)32, (int)4, (int)12, (boolean)true, (boolean)false);
            SkinFilterCallback.copy((class_1011)image, (int)8, (int)20, (int)8, (int)32, (int)4, (int)12, (boolean)true, (boolean)false);
            SkinFilterCallback.copy((class_1011)image, (int)12, (int)20, (int)16, (int)32, (int)4, (int)12, (boolean)true, (boolean)false);
            SkinFilterCallback.copy((class_1011)image, (int)44, (int)16, (int)-8, (int)32, (int)4, (int)4, (boolean)true, (boolean)false);
            SkinFilterCallback.copy((class_1011)image, (int)48, (int)16, (int)-8, (int)32, (int)4, (int)4, (boolean)true, (boolean)false);
            SkinFilterCallback.copy((class_1011)image, (int)40, (int)20, (int)0, (int)32, (int)4, (int)12, (boolean)true, (boolean)false);
            SkinFilterCallback.copy((class_1011)image, (int)44, (int)20, (int)-8, (int)32, (int)4, (int)12, (boolean)true, (boolean)false);
            SkinFilterCallback.copy((class_1011)image, (int)48, (int)20, (int)-16, (int)32, (int)4, (int)12, (boolean)true, (boolean)false);
            SkinFilterCallback.copy((class_1011)image, (int)52, (int)20, (int)-8, (int)32, (int)4, (int)12, (boolean)true, (boolean)false);
        }
        if (!((SkinFilterCallback)SkinFilterCallback.EVENT.invoker()).shouldAllowTransparency(image, imageWidth, imageHeight)) {
            int scale = SkinFilterCallback.getResolutionScale((int)imageWidth, (int)imageHeight);
            HDPlayerSkinTextureDownloader.stripAlpha(image, 0, 0, 32 * scale, 16 * scale);
            if (SkinFilterCallback.isLegacyAspectRatio((int)imageWidth, (int)imageHeight)) {
                HDPlayerSkinTextureDownloader.stripColor(image, 32 * scale, 0, 64 * scale, 32 * scale);
            }
            HDPlayerSkinTextureDownloader.stripAlpha(image, 0, 16 * scale, 64 * scale, 32 * scale);
            HDPlayerSkinTextureDownloader.stripAlpha(image, 16 * scale, 48 * scale, 48 * scale, 64 * scale);
        }
        return ((SkinFilterCallback)SkinFilterCallback.EVENT.invoker()).processImage(image, imageWidth, imageHeight);
    }

    public static boolean isPowerOfTwo(int number) {
        return number != 0 && (number & number - 1) == 0;
    }

    public static boolean isValidShape(int w, int h) {
        return w > 0 && h > 0 && (w == h || w == 2 * h);
    }

    private static void stripColor(class_1011 image, int x1, int y1, int x2, int y2) {
        int j;
        int i;
        for (i = x1; i < x2; ++i) {
            for (j = y1; j < y2; ++j) {
                int k = image.method_61940(i, j);
                if ((k >> 24 & 0xFF) >= 128) continue;
                return;
            }
        }
        for (i = x1; i < x2; ++i) {
            for (j = y1; j < y2; ++j) {
                image.method_61941(i, j, image.method_61940(i, j) & 0xFFFFFF);
            }
        }
    }

    private static void stripAlpha(class_1011 image, int x1, int y1, int x2, int y2) {
        for (int i = x1; i < x2; ++i) {
            for (int j = y1; j < y2; ++j) {
                image.method_61941(i, j, class_9848.method_61334((int)image.method_61940(i, j)));
            }
        }
    }
}

