/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.hdskins.server;

import com.google.common.collect.Sets;
import com.minelittlepony.hdskins.HDSkinsServer;
import com.minelittlepony.hdskins.profile.ProfileUtils;
import com.minelittlepony.hdskins.profile.SkinType;
import com.minelittlepony.hdskins.server.Feature;
import com.minelittlepony.hdskins.server.ServerType;
import com.minelittlepony.hdskins.server.SkinServer;
import com.minelittlepony.hdskins.server.SkinUpload;
import com.minelittlepony.hdskins.server.TexturePayload;
import com.minelittlepony.hdskins.util.IndentedToStringStyle;
import com.minelittlepony.hdskins.util.net.FileTypes;
import com.minelittlepony.hdskins.util.net.MoreHttpResponses;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.exceptions.AuthenticationException;
import com.mojang.authlib.minecraft.InsecurePublicKeyException;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.yggdrasil.ProfileResult;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Nullable;

@ServerType(value="mojang")
public class YggdrasilSkinServer
implements SkinServer {
    static final SkinServer INSTANCE = new YggdrasilSkinServer();
    private static final Set<Feature> FEATURES = Sets.newHashSet((Object[])new Feature[]{Feature.SYNTHETIC, Feature.UPLOAD_USER_SKIN, Feature.DOWNLOAD_USER_SKIN, Feature.DELETE_USER_SKIN, Feature.MODEL_VARIANTS, Feature.MODEL_TYPES});
    private static final Set<Feature> READ_ONLY_FEATURES = Sets.newHashSet((Object[])new Feature[]{Feature.SYNTHETIC, Feature.DOWNLOAD_USER_SKIN, Feature.DELETE_USER_SKIN, Feature.MODEL_VARIANTS, Feature.MODEL_TYPES});
    private static final URI LOGIN_URI = URI.create("https://www.minecraft.net/en-us/login");
    private final transient String address = "https://api.minecraftservices.com";
    private final transient String profileAddress = "https://api.minecraftservices.com/minecraft/profile";
    private final transient String skinUploadAddress = "https://api.minecraftservices.com/minecraft/profile/skins";
    private final transient String activeSkinAddress = "https://api.minecraftservices.com/minecraft/profile/skins/active";
    private final transient String activeCapeAddress = "https://api.minecraftservices.com/minecraft/profile/capes/active";
    private final transient boolean requireSecure = true;

    @Override
    public boolean ownsUrl(String url) {
        return false;
    }

    @Override
    public Set<Feature> getFeatures() {
        return FEATURES;
    }

    @Override
    public Set<Feature> getFeatures(SkinType skinType) {
        return skinType != SkinType.SKIN ? READ_ONLY_FEATURES : FEATURES;
    }

    @Override
    public boolean supportsSkinType(SkinType skinType) {
        return skinType.isVanilla();
    }

    @Override
    public TexturePayload loadSkins(GameProfile profile) throws IOException, AuthenticationException {
        MinecraftSessionService service = HDSkinsServer.getInstance().getSessionService();
        @Nullable ProfileResult result = service.fetchProfile(profile.id(), true);
        if (result == null) {
            throw new AuthenticationException("Mojang API error occured. You may be throttled.");
        }
        try {
            profile = result.profile();
            return new TexturePayload(profile, ProfileUtils.readVanillaTexturesBlob(service, profile).findFirst().orElseGet(HashMap::new));
        }
        catch (InsecurePublicKeyException e) {
            throw new AuthenticationException((Throwable)e);
        }
    }

    @Override
    public TexturePayload loadSkins(SkinUpload.Session session) throws IOException, AuthenticationException {
        @Nullable TexturePayload payload = this.loadProfile(session).map(profile -> {
            HashMap<SkinType, MinecraftProfileTexture> textures = new HashMap<SkinType, MinecraftProfileTexture>();
            profile.skins.stream().filter(i -> i.isActive()).findFirst().ifPresent(skin -> textures.put(SkinType.SKIN, new MinecraftProfileTexture(skin.url, Map.of("model", "classic".equalsIgnoreCase(skin.variant) ? "default" : skin.variant.toLowerCase(Locale.ROOT)))));
            profile.capes.stream().filter(i -> i.isActive()).findFirst().ifPresent(skin -> {
                textures.put(SkinType.CAPE, new MinecraftProfileTexture(skin.url, Map.of()));
                textures.put(SkinType.ELYTRA, new MinecraftProfileTexture(skin.url, Map.of()));
            });
            return new TexturePayload(session.profile(), textures);
        }).orElse(null);
        if (payload == null) {
            return this.loadSkins(session.profile());
        }
        return payload;
    }

    @Override
    public void uploadSkin(SkinUpload upload) throws IOException, AuthenticationException {
        this.authorize(upload.session());
        if (upload instanceof SkinUpload.Delete) {
            this.execute(HttpRequest.newBuilder(URI.create(upload.type() == SkinType.SKIN ? "https://api.minecraftservices.com/minecraft/profile/skins/active" : "https://api.minecraftservices.com/minecraft/profile/capes/active")).DELETE().header("Authorization", "Bearer " + upload.session().accessToken()));
        } else if (upload instanceof SkinUpload.FileUpload) {
            SkinUpload.FileUpload fileUpload = (SkinUpload.FileUpload)upload;
            this.execute(FileTypes.multiPart(this.mapMetadata(fileUpload.metadata())).field("file", fileUpload.file()).build(HttpRequest.newBuilder(URI.create("https://api.minecraftservices.com/minecraft/profile/skins"))::POST).header("Accept", "application/json").header("Authorization", "Bearer " + upload.session().accessToken()));
        } else if (upload instanceof SkinUpload.UriUpload) {
            SkinUpload.UriUpload uriUpload = (SkinUpload.UriUpload)upload;
            this.execute(FileTypes.multiPart(this.mapMetadata((Map)class_156.method_654(uriUpload.metadata(), metadata -> metadata.put("url", uriUpload.uri().toString())))).build(HttpRequest.newBuilder(URI.create("https://api.minecraftservices.com/minecraft/profile/skins"))::POST).header("Accept", "application/json").header("Authorization", "Bearer " + upload.session().accessToken()));
        } else {
            throw new IllegalArgumentException("Unsupported SkinUpload type: " + String.valueOf(upload.getClass()));
        }
    }

    private Map<String, String> mapMetadata(Map<String, String> metadata) {
        HashMap<String, String> result = new HashMap<String, String>();
        String model = metadata.getOrDefault("model", "classic");
        result.put("variant", "default".contentEquals(model) ? "classic" : model);
        return result;
    }

    @Override
    public void authorize(SkinUpload.Session session) throws IOException {
    }

    private void execute(HttpRequest.Builder request) throws IOException {
        MoreHttpResponses response = MoreHttpResponses.execute(request);
        if (!response.ok()) {
            throw new IOException(response.json(ErrorResponse.class, "Server did not respond correctly. Status Code " + response.response().statusCode()).toString());
        }
    }

    public void setActiveCape(SkinUpload.Session session, String capeId) throws IOException, AuthenticationException {
        this.authorize(session);
        this.execute(HttpRequest.newBuilder(URI.create("https://api.minecraftservices.com/minecraft/profile/capes/active")).PUT(FileTypes.json(Map.of("capeId", capeId))).header("Authorization", "Bearer " + session.accessToken()));
    }

    public Optional<ProfileResponse> loadProfile(SkinUpload.Session session) throws IOException, AuthenticationException {
        MoreHttpResponses response = MoreHttpResponses.execute(HttpRequest.newBuilder(URI.create("https://api.minecraftservices.com/minecraft/profile")).GET().header("Authorization", "Bearer " + session.accessToken()).build());
        if (!response.ok()) {
            return Optional.empty();
        }
        ProfileResponse prof = response.json(ProfileResponse.class, "Server send invalid profile response");
        prof.session = session;
        prof.server = this;
        return Optional.of(prof);
    }

    public String toString() {
        return new IndentedToStringStyle.Builder(this).append("address", "https://api.minecraftservices.com").append("secured", true).toString();
    }

    @Override
    public Map<class_2561, class_2561> getMetadata() {
        return Map.of(class_2561.method_43471((String)"hdskins.label.website"), class_2561.method_43470((String)LOGIN_URI.toString()).method_27692(class_124.field_1073).method_54663(-16776961).method_27694(style -> style.method_10958((class_2558)new class_2558.class_10608(LOGIN_URI))), class_2561.method_43471((String)"hdskins.label.author"), class_2561.method_43470((String)"Mojang"));
    }

    class ErrorResponse {
        String error;
        String errorMessage;

        ErrorResponse(YggdrasilSkinServer this$0) {
        }

        public String toString() {
            return String.format("%s: %s", this.error, this.errorMessage);
        }
    }

    static class ProfileResponse
    implements SkinServer.SkinServerProfile<Skin> {
        public String id;
        public String name;
        public List<Skin> skins;
        public List<Skin> capes;
        transient SkinUpload.Session session;
        transient YggdrasilSkinServer server;

        ProfileResponse() {
        }

        @Override
        public List<Skin> getSkins(SkinType type) {
            if (type == SkinType.SKIN) {
                return this.skins;
            }
            if (type == SkinType.CAPE) {
                return this.capes;
            }
            return List.of();
        }

        @Override
        public void setActive(SkinType type, Skin texture) throws IOException, AuthenticationException {
            if (texture.state == State.ACTIVE) {
                return;
            }
            this.getSkins(type).forEach(s -> {
                s.state = State.INACTIVE;
            });
            texture.state = State.ACTIVE;
            if (type == SkinType.CAPE) {
                this.server.setActiveCape(this.session, texture.id);
            }
        }

        static class Skin
        implements SkinServer.SkinServerProfile.Skin {
            public String id;
            public State state;
            public String url;
            public String textureKey;
            public String variant;

            Skin() {
            }

            @Override
            public String getModel() {
                return this.variant;
            }

            @Override
            public boolean isActive() {
                return this.state == State.ACTIVE;
            }

            @Override
            public String getUri() {
                return this.url;
            }
        }

        static enum State {
            ACTIVE,
            INACTIVE;

        }
    }
}

