/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.hdskins.util.net;

import com.google.common.io.CharStreams;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.minelittlepony.hdskins.profile.SkinType;
import com.minelittlepony.hdskins.util.net.HttpException;
import com.mojang.util.UUIDTypeAdapter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.channels.UnresolvedAddressException;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;

@FunctionalInterface
public interface MoreHttpResponses {
    public static final int SC_MULTIPLE_CHOICES = 300;
    public static final HttpClient CLIENT = HttpClient.newHttpClient();
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(UUID.class, (Object)new UUIDTypeAdapter()).registerTypeHierarchyAdapter(SkinType.class, SkinType.adapter()).create();

    public static MoreHttpResponses execute(HttpRequest.Builder request) throws IOException {
        return MoreHttpResponses.execute(request.build());
    }

    public static MoreHttpResponses execute(HttpRequest request) throws IOException {
        try {
            HttpResponse<InputStream> response = CLIENT.send(request, HttpResponse.BodyHandlers.ofInputStream());
            return () -> response;
        }
        catch (InterruptedException | UnresolvedAddressException e) {
            throw new IOException(e);
        }
    }

    public HttpResponse<InputStream> response();

    default public boolean contentTypeMatches(String contentType) {
        return this.response().headers().allValues("Content-Type").stream().anyMatch(s -> s.toLowerCase().contains(contentType));
    }

    default public BufferedReader reader() throws IOException {
        return new BufferedReader(new InputStreamReader(this.response().body(), StandardCharsets.UTF_8));
    }

    default public String text() throws IOException {
        try (BufferedReader reader = this.reader();){
            String string = CharStreams.toString((Readable)reader);
            return string;
        }
    }

    default public <T> T json(Class<T> type, @Nullable String errorMessage) throws IOException {
        return this.json((Type)type, errorMessage);
    }

    default public <T> T json(Type type, String errorMessage) throws IOException {
        return this.json(type, () -> errorMessage);
    }

    default public <T> T json(Class<T> type, Supplier<String> errorMessage) throws IOException {
        return this.json((Type)type, errorMessage);
    }

    default public <T> T json(Type type, Supplier<String> errorMessage) throws IOException {
        String text = this.text();
        if (this.contentTypeMatches("application/json")) {
            return (T)GSON.fromJson(text, type);
        }
        throw new HttpException(String.format("%s\n%s", errorMessage.get(), text), this.response().statusCode(), null);
    }

    default public boolean ok() {
        return this.response().statusCode() < 300;
    }

    default public MoreHttpResponses requireOk() throws IOException {
        if (!this.ok()) {
            throw HttpException.of(this);
        }
        return this;
    }

    default public <T> Optional<T> accept(Untrusted<MoreHttpResponses, T> function) throws IOException {
        return this.ok() ? Optional.of(function.apply(this)) : Optional.empty();
    }

    public static interface Untrusted<A, B> {
        public B apply(A var1) throws IOException;
    }
}

