/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.hdskins.client.profile;

import com.google.common.hash.Hashing;
import com.minelittlepony.common.util.GamePaths;
import com.minelittlepony.hdskins.client.HDSkins;
import com.minelittlepony.hdskins.client.resources.HDPlayerSkinTextureDownloader;
import com.minelittlepony.hdskins.profile.SkinType;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2960;

class FileStore {
    private final Map<String, CompletableFuture<class_2960>> cache = new Object2ObjectOpenHashMap();

    FileStore() {
    }

    public CompletableFuture<class_2960> get(SkinType type, MinecraftProfileTexture texture) {
        String key = texture.getHash();
        CompletableFuture<class_2960> entry = this.cache.get(key);
        if (entry == null) {
            entry = this.store(type, texture);
            this.cache.put(key, entry);
        }
        return entry;
    }

    private CompletableFuture<class_2960> store(SkinType type, MinecraftProfileTexture texture) {
        String hash = Hashing.sha1().hashUnencodedChars((CharSequence)texture.getHash()).toString();
        class_2960 id = HDSkins.id(type.getPathName() + "/" + hash);
        Path path = this.getHDSkinsCache().resolve(type.getPathName()).resolve(hash.length() > 2 ? hash.substring(0, 2) : "xx").resolve(hash);
        return HDPlayerSkinTextureDownloader.downloadAndRegisterTexture(id, path, texture.getUrl(), type);
    }

    private Path getHDSkinsCache() {
        return GamePaths.getAssetsDirectory().resolve("hd");
    }

    public void clear() {
        try {
            Path cachePath = this.getHDSkinsCache();
            if (Files.exists(cachePath, new LinkOption[0])) {
                Files.walkFileTree(cachePath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(this){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        Files.delete(file);
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                        Files.delete(dir);
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            this.cache.clear();
        }
        catch (IOException e) {
            HDSkins.LOGGER.warn("Could not remove cache folder", (Throwable)e);
        }
    }
}

