/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.hdskins.server;

import com.google.common.base.Throwables;
import com.google.common.cache.LoadingCache;
import com.minelittlepony.hdskins.Memoize;
import com.minelittlepony.hdskins.profile.SkinType;
import com.minelittlepony.hdskins.server.SkinServer;
import com.minelittlepony.hdskins.server.SkinUpload;
import com.minelittlepony.hdskins.server.TexturePayload;
import com.minelittlepony.hdskins.util.net.HttpException;
import com.mojang.authlib.exceptions.AuthenticationException;
import com.mojang.authlib.exceptions.AuthenticationUnavailableException;
import com.mojang.authlib.exceptions.InvalidCredentialsException;
import java.io.IOException;
import java.nio.channels.UnresolvedAddressException;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.class_2561;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Gateway {
    public static final class_2561 ERR_SESSION = class_2561.method_43471((String)"hdskins.error.session");
    public static final class_2561 ERR_DNS = class_2561.method_43471((String)"hdskins.error.dns");
    private static final Logger LOGGER = LogManager.getLogger();
    private final SkinServer server;
    private final LoadingCache<SkinUpload.Session, CompletableFuture<Optional<? extends SkinServer.SkinServerProfile<?>>>> profiles;
    private boolean offline;
    private boolean throttled;
    private boolean busy;

    public Gateway(SkinServer server) {
        this.server = server;
        this.profiles = Memoize.createAsyncLoadingCache(15L, session -> CompletableFuture.supplyAsync(() -> {
            try {
                return server.loadProfile((SkinUpload.Session)session);
            }
            catch (AuthenticationException | IOException e) {
                return Optional.empty();
            }
        }));
    }

    public boolean isOnline() {
        return !this.offline;
    }

    public void setOffline(boolean offline) {
        this.offline = offline;
    }

    public boolean isThrottled() {
        return this.throttled;
    }

    public void setThrottled(boolean throttled) {
        this.throttled = throttled;
    }

    public boolean isBusy() {
        return this.busy;
    }

    public void setBusy(boolean busy) {
        this.busy = busy;
    }

    public SkinServer getServer() {
        return this.server;
    }

    public Stream<SkinType> getSupportedSkinTypes() {
        return SkinType.REGISTRY.method_10220().filter(this.server::supportsSkinType).distinct();
    }

    public CompletableFuture<Optional<? extends SkinServer.SkinServerProfile<?>>> getProfile(SkinUpload.Session session) {
        return (CompletableFuture)this.profiles.getUnchecked((Object)session);
    }

    public CompletableFuture<Void> uploadSkin(SkinUpload payload, Consumer<class_2561> errorCallback) {
        return CompletableFuture.runAsync(() -> {
            try {
                this.setBusy(true);
                this.server.uploadSkin(payload);
                this.profiles.invalidateAll();
            }
            catch (Exception e) {
                this.handleException(e, errorCallback);
            }
            finally {
                this.setBusy(false);
            }
        });
    }

    public <K extends SkinServer.SkinServerProfile.Skin> CompletableFuture<Void> swapSkin(SkinServer.SkinServerProfile<K> profile, SkinType type, int index, Consumer<class_2561> errorCallback) {
        return CompletableFuture.runAsync(() -> {
            try {
                this.setBusy(true);
                profile.setActive(type, (SkinServer.SkinServerProfile.Skin)profile.getSkins(type).get(index));
                this.profiles.invalidateAll();
            }
            catch (Exception e) {
                this.handleException(e, errorCallback);
            }
            finally {
                this.setBusy(false);
            }
        });
    }

    public CompletableFuture<TexturePayload> fetchSkins(SkinUpload.Session session, Consumer<class_2561> errorCallback) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                this.setBusy(true);
                TexturePayload texturePayload = this.server.loadSkins(session);
                return texturePayload;
            }
            catch (Exception e) {
                this.handleException(e, errorCallback);
                throw new RuntimeException(e);
            }
            finally {
                this.setBusy(false);
            }
        });
    }

    public void handleException(Throwable throwable, Consumer<class_2561> errorCallback) {
        throwable = Throwables.getRootCause((Throwable)throwable);
        this.setBusy(false);
        if (throwable instanceof HttpException) {
            HttpException ex = (HttpException)throwable;
            int code = ex.getStatusCode();
            if (code >= 500) {
                LOGGER.error(ex.getReasonPhrase(), (Throwable)ex);
                errorCallback.accept((class_2561)class_2561.method_43470((String)("A fatal server error has ocurred (check logs for details): \n" + ex.getReasonPhrase())));
            } else if (code >= 400 && code != 403 && code != 404) {
                LOGGER.error(ex.getReasonPhrase(), (Throwable)ex);
                errorCallback.accept((class_2561)class_2561.method_43470((String)ex.getReasonPhrase()));
            } else {
                LOGGER.error(ex.getReasonPhrase(), (Throwable)ex);
            }
        } else {
            LOGGER.error("Unexpected error whilst contacting server at " + this.server.toString(), throwable);
            if (throwable instanceof AuthenticationUnavailableException) {
                this.setOffline(true);
            } else if (throwable instanceof UnresolvedAddressException) {
                errorCallback.accept(ERR_DNS);
                this.setOffline(true);
            } else if (throwable instanceof InvalidCredentialsException) {
                errorCallback.accept(ERR_SESSION);
            } else if (throwable instanceof AuthenticationException) {
                this.setThrottled(true);
            } else {
                LOGGER.error("Unhandled exception", throwable);
                errorCallback.accept((class_2561)class_2561.method_43470((String)throwable.toString()));
            }
        }
    }
}

