/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.hdskins.client.gui.filesystem.os;

import com.minelittlepony.hdskins.client.HDSkins;
import com.minelittlepony.hdskins.client.gui.filesystem.FileDialog;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import net.minecraft.class_310;
import org.jetbrains.annotations.Nullable;

abstract class AbstractNativeFileDialog
implements FileDialog {
    private static final Executor EXECUTOR = Executors.newSingleThreadExecutor();
    protected Path currentDirectory;
    @Nullable
    protected String extensionFilter;
    @Nullable
    protected String filterMessage;
    private FileDialog.Callback callback;

    AbstractNativeFileDialog() {
        this.currentDirectory = (Path)HDSkins.getInstance().getConfig().lastChosenFile.get();
        this.callback = (file, done) -> {};
    }

    @Override
    public FileDialog startIn(Path currentDirectory) {
        this.currentDirectory = currentDirectory;
        return this;
    }

    @Override
    public FileDialog filter(String extension, String description) {
        this.extensionFilter = extension;
        this.filterMessage = description;
        return this;
    }

    @Override
    public FileDialog andThen(FileDialog.Callback callback) {
        this.callback = callback;
        return this;
    }

    @Nullable
    protected abstract String runFileDialog();

    @Override
    public FileDialog launch() {
        CompletableFuture.supplyAsync(() -> {
            String file = this.runFileDialog();
            if (file == null) {
                return null;
            }
            return Paths.get(file, new String[0]);
        }, EXECUTOR).thenAcceptAsync(result -> this.callback.onDialogClosed((Path)result, true), (Executor)class_310.method_1551());
        return this;
    }
}

