/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.hdskins.client;

import com.minelittlepony.hdskins.client.HDSkins;
import com.minelittlepony.hdskins.client.VanillaModels;
import com.minelittlepony.hdskins.client.ducks.ClientPlayerInfo;
import com.minelittlepony.hdskins.mixin.client.MixinClientPlayer;
import com.minelittlepony.hdskins.profile.SkinType;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1071;
import net.minecraft.class_2960;
import net.minecraft.class_742;
import org.jetbrains.annotations.Nullable;

public class PlayerSkins {
    private final ClientPlayerInfo playerInfo;
    private final Set<class_2960> providedSkinTypes = new HashSet<class_2960>();
    private final Map<SkinType, class_2960> customTextures = new HashMap<SkinType, class_2960>();
    private final Map<SkinType, MinecraftProfileTexture> customProfiles = new HashMap<SkinType, MinecraftProfileTexture>();
    private final Map<SkinType, MinecraftProfileTexture> vanillaProfiles = new HashMap<SkinType, MinecraftProfileTexture>();

    @Nullable
    public static PlayerSkins of(class_742 player) {
        ClientPlayerInfo info = (ClientPlayerInfo)((MixinClientPlayer)player).getBackingClientData();
        if (info == null) {
            return null;
        }
        return info.getSkins();
    }

    public PlayerSkins(ClientPlayerInfo playerInfo) {
        this.playerInfo = playerInfo;
    }

    public Set<class_2960> getProvidedSkinTypes() {
        return this.providedSkinTypes;
    }

    @Nullable
    public class_2960 getSkin(SkinType type) {
        return HDSkins.getInstance().getResourceManager().getCustomPlayerTexture(this.playerInfo.getGameProfile(), type).orElseGet(() -> Optional.ofNullable(this.customTextures.get(type)).orElseGet(() -> type.getEnum().map(this.playerInfo.getVanillaTextures()::get).orElse(null)));
    }

    @Nullable
    public String getModel() {
        return HDSkins.getInstance().getResourceManager().getCustomPlayerModel(this.playerInfo.getGameProfile()).orElseGet(() -> this.getModelFrom(this.customProfiles).orElseGet(() -> this.getModelFrom(this.vanillaProfiles).orElse(null)));
    }

    public void load(class_1071 provider, GameProfile profile, boolean requireSecure) {
        HDSkins.getInstance().getProfileRepository().fetchSkins(profile, this::onCustomTextureLoaded);
        provider.method_4652(profile, this::onVanillaTextureLoaded, requireSecure);
    }

    private void onCustomTextureLoaded(SkinType type, class_2960 location, MinecraftProfileTexture profileTexture) {
        this.customTextures.put(type, location);
        this.customProfiles.put(type, profileTexture);
        this.providedSkinTypes.add(type.getId());
    }

    private void onVanillaTextureLoaded(MinecraftProfileTexture.Type type, class_2960 location, MinecraftProfileTexture profileTexture) {
        this.playerInfo.getVanillaTextures().put(type, location);
        this.vanillaProfiles.put(SkinType.forVanilla(type), profileTexture);
        this.providedSkinTypes.add(SkinType.forVanilla(type).getId());
    }

    private Optional<String> getModelFrom(Map<SkinType, MinecraftProfileTexture> texture) {
        return Optional.ofNullable(texture.get(SkinType.SKIN)).map(t -> VanillaModels.of(t.getMetadata("model")));
    }
}

