/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.hdskins.client.gui;

import com.minelittlepony.common.client.gui.ITextContext;
import com.minelittlepony.common.client.gui.dimension.Bounds;
import com.minelittlepony.hdskins.client.HDSkins;
import com.minelittlepony.hdskins.client.gui.player.DummyPlayer;
import com.minelittlepony.hdskins.client.gui.player.DummyPlayerRenderer;
import com.minelittlepony.hdskins.client.gui.player.DummyWorld;
import com.minelittlepony.hdskins.client.gui.player.skins.PlayerSkins;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_2246;
import net.minecraft.class_2561;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_638;
import net.minecraft.class_7833;
import net.minecraft.class_898;

public class Carousel<T extends PlayerSkins<? extends PlayerSkins.PlayerSkin>>
implements Closeable,
ITextContext {
    public static final int HOR_MARGIN = 30;
    private static final int TOP = 50;
    private final class_310 minecraft = class_310.method_1551();
    private final class_2561 title;
    private Optional<DummyPlayer> entity = Optional.empty();
    private final T skins;
    public final Bounds bounds = new Bounds(50, 30, 0, 0);
    private final List<Element> elements = new ArrayList<Element>();

    public Carousel(class_2561 title, T skins, BiFunction<class_638, PlayerSkins<?>, DummyPlayer> playerFactory) {
        this.title = title;
        this.skins = skins;
        DummyWorld.getOrDummyFuture().thenAcceptAsync(w -> {
            try {
                this.entity = Optional.of((DummyPlayer)((Object)((Object)playerFactory.apply((class_638)w, (PlayerSkins<?>)skins))));
            }
            catch (Throwable t) {
                HDSkins.LOGGER.error("Error creating players", t);
            }
        }, (Executor)class_310.method_1551());
    }

    public void addElement(Element element) {
        this.elements.add(element);
    }

    public Optional<DummyPlayer> getEntity() {
        return this.entity;
    }

    public T getSkins() {
        return this.skins;
    }

    public boolean mouseClicked(int width, int height, double mouseX, double mouseY, int button) {
        if (this.bounds.contains(mouseX, mouseY)) {
            this.entity.ifPresent(p -> p.method_6104(button == 0 ? class_1268.field_5808 : class_1268.field_5810));
            return true;
        }
        return false;
    }

    public void render(int mouseX, int mouseY, int ticks, float partialTick, class_332 context) {
        context.method_44379(this.bounds.left, this.bounds.top, this.bounds.right(), this.bounds.bottom());
        int horizon = this.bounds.bottom() - 50;
        this.drawBackground(context, horizon);
        this.entity.ifPresent(player -> {
            try {
                DummyPlayerRenderer.wrap(() -> {
                    this.renderPlayerModel((DummyPlayer)((Object)player), context, this.bounds.left + this.bounds.width / 2, (float)this.bounds.top + (float)this.bounds.height * 0.9f, (float)this.bounds.height / 3.0f, mouseX, this.bounds.top + this.bounds.height / 2 - mouseY, (float)ticks + partialTick);
                    this.elements.forEach(element -> element.render((DummyPlayer)((Object)player), context, mouseX, mouseY));
                });
            }
            catch (Exception e) {
                HDSkins.LOGGER.error("Exception whilst rendering player preview.", (Throwable)e);
            }
        });
        context.method_51452();
        context.method_44380();
        context.method_51448().method_22903();
        this.bounds.translate(context.method_51448());
        this.drawLabel(context, this.title, 5, 5, 0xFFFFFF, 900.0);
        context.method_51448().method_22909();
    }

    protected void drawBackground(class_332 context, int horizon) {
        this.bounds.draw(context, -1610612736);
        context.method_25296(this.bounds.left, horizon, this.bounds.right(), this.bounds.bottom(), 0x5FFFFFF, 0x40FFFFFF);
    }

    protected void renderPlayerModel(DummyPlayer thePlayer, class_332 context, float xPosition, float yPosition, float scale, float mouseX, float mouseY, float ticks) {
        class_898 dispatcher = this.minecraft.method_1561();
        if (dispatcher.method_3953((class_1297)thePlayer) == null) {
            HDSkins.LOGGER.warn("Entity " + thePlayer.toString() + " does not have a valid renderer. Did resource loading fail?");
            return;
        }
        float rot = ticks * 2.5f % 360.0f;
        float lookFactor = (float)Math.sin((double)rot * (Math.PI / 180) + 45.0);
        float lookX = (float)Math.atan((xPosition - mouseX) / 20.0f) * -30.0f;
        thePlayer.method_5847(lookX * lookFactor);
        thePlayer.method_36457(thePlayer.method_6113() ? 10.0f : (float)Math.atan(mouseY / 40.0f) * -20.0f);
        class_4587 modelStack = RenderSystem.getModelViewStack();
        modelStack.method_22903();
        modelStack.method_46416(xPosition, yPosition, 1050.0f);
        modelStack.method_22905(1.0f, 1.0f, -1.0f);
        RenderSystem.applyModelViewMatrix();
        class_4587 matrixStack = context.method_51448();
        matrixStack.method_22903();
        matrixStack.method_46416(0.0f, 0.0f, 1000.0f);
        matrixStack.method_22905(scale, scale, scale);
        matrixStack.method_22907(class_7833.field_40714.rotationDegrees(15.0f));
        matrixStack.method_22907(class_7833.field_40718.rotationDegrees(180.0f));
        matrixStack.method_22907(class_7833.field_40716.rotationDegrees(rot));
        class_308.method_34742();
        class_4597.class_4598 immediate = class_310.method_1551().method_22940().method_23000();
        this.renderPlayerEntity(matrixStack, thePlayer, (class_4597)immediate, dispatcher);
        immediate.method_22993();
        matrixStack.method_22909();
        modelStack.method_22909();
        RenderSystem.applyModelViewMatrix();
        class_308.method_24211();
    }

    protected void renderPlayerEntity(class_4587 matrixStack, DummyPlayer thePlayer, class_4597 renderContext, class_898 dispatcher) {
        if (thePlayer.method_6113()) {
            DummyPlayerRenderer.BedHead.instance.render((class_1297)thePlayer, matrixStack, renderContext);
        }
        if (thePlayer.method_5765()) {
            thePlayer.boat.render(matrixStack, renderContext);
        }
        double offset = thePlayer.method_23318();
        if (thePlayer.method_5765()) {
            offset = thePlayer.method_5621() - (double)thePlayer.method_17682();
        }
        float x = 0.0f;
        float y = 0.0f;
        float z = 0.0f;
        if (thePlayer.method_5715()) {
            y = (float)((double)y + 0.125);
        }
        matrixStack.method_22903();
        matrixStack.method_22904(0.001, offset, 0.001);
        if (thePlayer.method_6113()) {
            matrixStack.method_22907(class_7833.field_40716.rotationDegrees(90.0f));
            y += 0.7f;
            x += 1.0f;
        }
        if (thePlayer.method_5681()) {
            DummyWorld.fillWith(class_2246.field_10382.method_9564());
            matrixStack.method_22907(class_7833.field_40713.rotationDegrees(45.0f));
            if (thePlayer.method_18798().field_1352 < 100.0) {
                thePlayer.method_5762(100.0, 0.0, 0.0);
            }
            y += 0.5f;
            x += 0.0f;
            z += 1.0f;
        } else {
            DummyWorld.fillWith(class_2246.field_10124.method_9564());
            if (thePlayer.method_18798().field_1352 >= 100.0) {
                thePlayer.method_5762(-100.0, 0.0, 0.0);
            }
        }
        class_1297 camera = this.minecraft.method_1560();
        this.minecraft.method_1504((class_1297)thePlayer);
        dispatcher.method_3954((class_1297)thePlayer, (double)x, (double)y, (double)z, 0.0f, 1.0f, matrixStack, renderContext, 0xF000F0);
        this.minecraft.method_1504(camera);
        matrixStack.method_22909();
    }

    @Override
    public void close() {
        ((PlayerSkins)this.skins).close();
    }

    public static interface Element {
        public void render(DummyPlayer var1, class_332 var2, int var3, int var4);
    }
}

