/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.hdskins.client.gui;

import com.minelittlepony.common.client.gui.ITextContext;
import com.minelittlepony.hdskins.client.HDSkins;
import com.minelittlepony.hdskins.client.VanillaSkins;
import com.minelittlepony.hdskins.client.gui.Carousel;
import com.minelittlepony.hdskins.client.gui.Controls;
import com.minelittlepony.hdskins.client.gui.GuiSkins;
import com.minelittlepony.hdskins.client.gui.SkinChooser;
import com.minelittlepony.hdskins.client.gui.SkinListWidget;
import com.minelittlepony.hdskins.client.gui.SkinUploader;
import com.minelittlepony.hdskins.client.gui.player.DummyPlayer;
import com.minelittlepony.hdskins.client.gui.player.skins.LocalPlayerSkins;
import com.minelittlepony.hdskins.client.gui.player.skins.PlayerSkins;
import com.minelittlepony.hdskins.client.gui.player.skins.ServerPlayerSkins;
import com.minelittlepony.hdskins.client.resources.EquipmentList;
import com.minelittlepony.hdskins.client.resources.NativeImageFilters;
import com.minelittlepony.hdskins.client.resources.TextureLoader;
import com.minelittlepony.hdskins.profile.SkinType;
import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_638;

public class DualCarouselWidget
implements Closeable,
PlayerSkins.Posture,
ITextContext {
    private static final int PASSIVE_ROTATION_SPEED = 1;
    private static final int MAX_MANUAL_ROTATION_SPEED = 20;
    protected final class_310 minecraft = class_310.method_1551();
    protected final GameProfile profile = this.minecraft.method_1548().method_1677();
    public final Carousel<LocalPlayerSkins> local;
    public final Carousel<ServerPlayerSkins> remote;
    private final SkinListWidget skinList;
    private PlayerSkins.Posture.Pose pose = PlayerSkins.Posture.Pose.STAND;
    private SkinType activeSkinType = SkinType.SKIN;
    private Optional<PlayerSkins.Posture.SkinVariant> variant = Optional.empty();
    private List<PlayerSkins.Posture.SkinVariant> skinVariants = new ArrayList<PlayerSkins.Posture.SkinVariant>(PlayerSkins.Posture.SkinVariant.VALUES);
    private EquipmentList.EquipmentSet activeEquipmentSet = HDSkins.getInstance().getDummyPlayerEquipmentList().getDefault();
    protected final Controls controls;
    private float updateCounter = 72.0f;
    private float rotationSpeed;
    private int prevRotationDirection;
    private final GuiSkins screen;

    public DualCarouselWidget(GuiSkins screen) {
        this.screen = screen;
        this.local = new Carousel<LocalPlayerSkins>((class_2561)class_2561.method_43471((String)"hdskins.local"), new LocalPlayerSkins(this), this::createEntity);
        this.remote = new Carousel<ServerPlayerSkins>((class_2561)class_2561.method_43471((String)"hdskins.server"), new ServerPlayerSkins(this), this::createEntity);
        this.skinList = new SkinListWidget(this, this.remote.bounds);
        this.controls = new Controls(this);
        this.remote.addElement(this.skinList);
    }

    protected DummyPlayer createEntity(class_638 world, PlayerSkins<?> textures) {
        return new DummyPlayer(world, textures);
    }

    public Carousel<ServerPlayerSkins> getRemote() {
        return this.remote;
    }

    public Carousel<LocalPlayerSkins> getLocal() {
        return this.local;
    }

    public void setEquipment(EquipmentList.EquipmentSet equipment) {
        this.activeEquipmentSet = equipment;
        this.apply(this.activeEquipmentSet::apply);
    }

    @Override
    public EquipmentList.EquipmentSet getEquipment() {
        return this.activeEquipmentSet;
    }

    @Override
    public GameProfile getProfile() {
        return this.profile;
    }

    public void setPose(PlayerSkins.Posture.Pose pose) {
        this.pose = pose;
    }

    @Override
    public PlayerSkins.Posture.Pose getPose() {
        return this.pose;
    }

    public void setSkinVariant(PlayerSkins.Posture.SkinVariant variant) {
        this.variant = Optional.of(variant);
        this.local.getSkins().close();
    }

    public List<PlayerSkins.Posture.SkinVariant> getSkinVariants() {
        return this.skinVariants;
    }

    @Override
    public Optional<PlayerSkins.Posture.SkinVariant> getSkinVariant() {
        return this.variant;
    }

    public void setSkinType(SkinType type) {
        this.activeSkinType = type;
    }

    @Override
    public SkinType getActiveSkinType() {
        return this.activeSkinType;
    }

    @Override
    public class_2960 getDefaultSkin(SkinType type, String variant) {
        class_2960 skin = this.getBlankSkin(type, variant);
        return NativeImageFilters.GREYSCALE.load(type == SkinType.SKIN ? VanillaSkins.getTexture(this.getProfile().getId(), variant) : skin, skin, this.getExclusion());
    }

    @Override
    public TextureLoader.Exclusion getExclusion() {
        return TextureLoader.Exclusion.NULL;
    }

    public class_2960 getBlankSkin(SkinType type, String variant) {
        return VanillaSkins.getDefaultTexture(type, variant);
    }

    public void setJumping(boolean jumping) {
        this.apply(p -> p.method_6100(jumping));
    }

    public void setSneaking(boolean sneaking) {
        this.apply(p -> p.method_5660(sneaking));
    }

    public void setSprinting(boolean walking) {
        this.apply(p -> p.method_5728(walking));
    }

    public void apply(Consumer<DummyPlayer> action) {
        this.getLocal().getEntity().ifPresent(action);
        this.getRemote().getEntity().ifPresent(action);
    }

    public void init() {
        this.local.bounds.left = 30;
        this.local.bounds.height = this.screen.field_22790 - 90;
        this.local.bounds.width = this.screen.field_22789 / 2 - 70;
        this.remote.bounds.copy(this.local.bounds);
        this.remote.bounds.left = this.screen.field_22789 - 30 - this.remote.bounds.width;
        this.skinList.init(this.screen);
    }

    public void update() {
        int rotationDirection;
        this.controls.update();
        class_310 client = class_310.method_1551();
        boolean left = client.field_1690.field_1913.method_1434();
        boolean right = client.field_1690.field_1849.method_1434();
        int n = left ? -1 : (rotationDirection = right ? 1 : 0);
        if (!(left && right || this.screen.method_25397())) {
            if (rotationDirection == 0) {
                this.rotationSpeed = (int)Math.max(1.0f, this.rotationSpeed * 0.6f);
                this.updateCounter += this.rotationSpeed;
            } else {
                if (this.prevRotationDirection != rotationDirection) {
                    this.rotationSpeed = 1.0f;
                }
                this.rotationSpeed = Math.min(20.0f, this.rotationSpeed + 1.0f);
                this.updateCounter -= this.rotationSpeed * (float)rotationDirection;
            }
        }
        this.prevRotationDirection = rotationDirection;
    }

    public void render(class_332 context, int mouseX, int mouseY, float partialTick, SkinChooser chooser, SkinUploader uploader) {
        RenderSystem.enableDepthTest();
        this.local.render(mouseX, mouseY, (int)this.updateCounter, partialTick, context);
        this.remote.render(mouseX, mouseY, (int)this.updateCounter, partialTick, context);
        RenderSystem.disableDepthTest();
        chooser.renderStatus(context, this.local.bounds);
        uploader.renderStatus(context, this.remote.bounds);
    }

    public boolean mouseClicked(SkinUploader uploader, int width, int height, double mouseX, double mouseY, int button) {
        boolean playerHit;
        boolean listHit = this.skinList.mouseClicked(uploader, mouseX, mouseY, button);
        boolean bl = playerHit = this.local.mouseClicked(width, height, mouseX, mouseY, button) || this.remote.mouseClicked(width, height, mouseX, mouseY, button);
        if (playerHit && !listHit && button == 0) {
            this.screen.method_25398(true);
        }
        return listHit || playerHit;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double changeX, double changeY) {
        if (this.screen.method_25397()) {
            this.updateCounter = (float)((double)this.updateCounter + changeX);
        }
        return true;
    }

    @Override
    public void close() {
        this.remote.close();
        this.local.close();
    }
}

