/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.hdskins.client.gui;

import com.minelittlepony.hdskins.client.HDSkins;
import com.minelittlepony.hdskins.client.gui.CarouselStatusLabel;
import com.minelittlepony.hdskins.client.gui.ConfirmationScreen;
import com.minelittlepony.hdskins.client.gui.DualCarouselWidget;
import com.minelittlepony.hdskins.client.gui.SkinUploader;
import com.minelittlepony.hdskins.client.gui.filesystem.FileDialogs;
import com.minelittlepony.hdskins.client.gui.filesystem.FileSystemUtil;
import com.minelittlepony.hdskins.client.gui.filesystem.WatchedFile;
import com.minelittlepony.hdskins.client.gui.player.skins.LocalPlayerSkins;
import com.minelittlepony.hdskins.client.gui.player.skins.ServerPlayerSkins;
import com.minelittlepony.hdskins.profile.SkinType;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_1011;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;
import org.apache.commons.io.FilenameUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class SkinChooser
implements CarouselStatusLabel {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final int MAX_SKIN_DIMENSION = 1024;
    public static final String[] EXTENSIONS = new String[]{"png", "PNG"};
    public static final class_2561 ERR_UNREADABLE = class_2561.method_43471((String)"hdskins.error.unreadable");
    public static final class_2561 ERR_EXT = class_2561.method_43471((String)"hdskins.error.ext");
    public static final class_2561 ERR_OPEN = class_2561.method_43471((String)"hdskins.error.open");
    public static final class_2561 ERR_INVALID_TOO_LARGE = class_2561.method_43471((String)"hdskins.error.invalid.too_large");
    public static final class_2561 ERR_INVALID_SHAPE = class_2561.method_43471((String)"hdskins.error.invalid.shape");
    public static final class_2561 ERR_INVALID_POWER_OF_TWO = class_2561.method_43471((String)"hdskins.error.invalid.power_of_two");
    public static final class_2561 ERR_INVALID = class_2561.method_43471((String)"hdskins.error.invalid");
    public static final class_2561 MSG_CHOOSE = class_2561.method_43471((String)"hdskins.choose");
    private boolean pickingInProgress;
    private final DualCarouselWidget previewer;
    private Consumer<SkinType> listener = t -> {};
    private final List<Function<class_1011, class_2561>> validators = new ArrayList<Function<class_1011, class_2561>>();
    private final WatchedFile localSkin = new WatchedFile(this::fileChanged, this::fileRemoved);
    private volatile class_2561 status = MSG_CHOOSE;

    private static boolean isPowerOfTwo(int number) {
        return number != 0 && (number & number - 1) == 0;
    }

    public SkinChooser(DualCarouselWidget previewer) {
        this.previewer = previewer;
        this.addImageValidation(this::acceptsSkinDimensions);
    }

    public void addSkinChangedEventListener(Consumer<SkinType> listener) {
        this.listener = this.listener.andThen(listener);
    }

    private FileDialogs getFileDialogs() {
        if (FileSystemUtil.IS_SANDBOXED && ((Boolean)HDSkins.getInstance().getConfig().enableSandboxingCheck.get()).booleanValue() || ((Boolean)HDSkins.getInstance().getConfig().useNativeFileChooser.get()).booleanValue()) {
            return FileDialogs.NATIVE;
        }
        return FileDialogs.INTEGRATED;
    }

    public void addImageValidation(Function<class_1011, class_2561> validator) {
        this.validators.add(validator);
    }

    private void fileRemoved() {
        class_310.method_1551().execute(this.previewer.getLocal().getSkins()::close);
    }

    private void fileChanged(Path path) {
        try {
            SkinType skinType = this.previewer.getActiveSkinType();
            LOGGER.debug("Set {} {}", (Object)skinType, (Object)path);
            ((LocalPlayerSkins.LocalTexture)this.previewer.getLocal().getSkins().get(skinType)).setLocal(path);
            this.listener.accept(skinType);
        }
        catch (IOException e) {
            HDSkins.LOGGER.error("Could not load local path `" + String.valueOf(path) + "`", (Throwable)e);
        }
    }

    public boolean pickingInProgress() {
        return this.pickingInProgress;
    }

    public class_2561 getStatus() {
        return this.status;
    }

    @Override
    public List<class_2561> getStatusLines() {
        return List.of(this.getStatus());
    }

    public int getStatusColor(class_2561 status) {
        return status == MSG_CHOOSE ? 0xFFFFFF : 0xFF5555;
    }

    @Override
    public boolean hasStatus() {
        return this.getStatus() != MSG_CHOOSE || !this.hasSelection();
    }

    public boolean hasSelection() {
        return !this.localSkin.isPending() && this.localSkin.isSet();
    }

    @Nullable
    public URI getSelection() {
        return this.localSkin.toUri();
    }

    public void update() {
        this.localSkin.update();
    }

    public void openBrowsePNG(String title) {
        this.pickingInProgress = true;
        this.getFileDialogs().open(title).filter(".png", "PNG Files (*.png)").andThen((file, success) -> {
            this.pickingInProgress = false;
            if (success) {
                this.selectFile(file);
            }
        }).launch();
    }

    public void openSavePNG(SkinUploader uploader, String title, String filename) {
        this.getFileDialogs().save(title, filename).filter(".png", "PNG Files (*.png)").andThen((file, success) -> {
            this.pickingInProgress = false;
            if (success) {
                ((ServerPlayerSkins.RemoteTexture)this.previewer.getRemote().getSkins().get(this.previewer.getActiveSkinType())).texture().ifPresent(texture -> {
                    try {
                        Files.deleteIfExists(file);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    try (InputStream response = texture.openStream();){
                        Files.copy(response, file, new CopyOption[0]);
                        class_310.method_1551().method_1507((class_437)new ConfirmationScreen(class_310.method_1551().field_1755, (class_2561)class_2561.method_43471((String)"hdskins.save.completed"), () -> class_156.method_668().method_673(file.toUri())));
                    }
                    catch (IOException e) {
                        LogManager.getLogger().error("Failed to save remote skin.", (Throwable)e);
                    }
                });
            }
        }).launch();
    }

    public void selectFile(Path skinFile) {
        this.status = this.evaluateAndSelect(skinFile);
    }

    private class_2561 evaluateAndSelect(Path skinFile) {
        class_2561 class_25612;
        block10: {
            if (!Files.exists(skinFile, new LinkOption[0])) {
                return ERR_UNREADABLE;
            }
            if (!FilenameUtils.isExtension((String)skinFile.getFileName().toString(), (String[])EXTENSIONS)) {
                return ERR_EXT;
            }
            InputStream in = Files.newInputStream(skinFile, new OpenOption[0]);
            try {
                class_1011 chosenImage = class_1011.method_4309((InputStream)in);
                class_25612 = this.validators.stream().map(f -> (class_2561)f.apply(chosenImage)).filter(Objects::nonNull).findFirst().orElseGet(() -> {
                    this.localSkin.set(skinFile);
                    return MSG_CHOOSE;
                });
                if (in == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    HDSkins.LOGGER.error("Exception occured whilst loading image file {}.", (Object)skinFile, (Object)e);
                    return ERR_OPEN;
                }
            }
            in.close();
        }
        return class_25612;
    }

    @Nullable
    protected class_2561 acceptsSkinDimensions(class_1011 img) {
        int w = img.method_4307();
        int h = img.method_4323();
        if (this.previewer.getActiveSkinType().isVanilla()) {
            if (!SkinChooser.isPowerOfTwo(w)) {
                return ERR_INVALID_POWER_OF_TWO;
            }
            if (w != h && w != h * 2) {
                return ERR_INVALID_SHAPE;
            }
        }
        if (w > 1024) {
            return ERR_INVALID_TOO_LARGE;
        }
        return null;
    }

    public static interface EventListener {
        default public void onSetLocalSkin(SkinType type) {
        }
    }
}

