/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.hdskins.client.gui;

import com.minelittlepony.common.client.gui.GameGui;
import com.minelittlepony.common.client.gui.dimension.Bounds;
import com.minelittlepony.common.client.gui.element.Button;
import com.minelittlepony.hdskins.client.HDSkins;
import com.minelittlepony.hdskins.client.gui.Carousel;
import com.minelittlepony.hdskins.client.gui.DualCarouselWidget;
import com.minelittlepony.hdskins.client.gui.GuiSkins;
import com.minelittlepony.hdskins.client.gui.SkinUploader;
import com.minelittlepony.hdskins.client.gui.player.DummyPlayer;
import com.minelittlepony.hdskins.client.gui.player.DummyWorld;
import com.minelittlepony.hdskins.client.gui.player.skins.PlayerSkins;
import com.minelittlepony.hdskins.client.gui.player.skins.PreviousServerPlayerSkins;
import com.minelittlepony.hdskins.client.gui.player.skins.ServerPlayerSkins;
import com.minelittlepony.hdskins.profile.SkinType;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import net.minecraft.class_1297;
import net.minecraft.class_2246;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_6880;
import net.minecraft.class_7833;
import net.minecraft.class_898;

public class SkinListWidget
implements Carousel.Element {
    private final DualCarouselWidget previewer;
    private final class_310 client = class_310.method_1551();
    private final Bounds containerBounds;
    private final Bounds bounds = new Bounds(0, 0, 0, 32);
    private float prevScrollPosition;
    private float scrollPosition;
    private int targetScrollPosition;
    private Button scrollLeft;
    private Button scrollRight;

    public SkinListWidget(DualCarouselWidget previewer, Bounds bounds) {
        this.previewer = previewer;
        this.containerBounds = bounds;
    }

    public void init(GuiSkins screen) {
        this.bounds.width = this.containerBounds.width - 20;
        this.bounds.left = this.containerBounds.left + 10;
        this.bounds.top = this.containerBounds.top + this.containerBounds.height - this.bounds.height;
        this.scrollLeft = new Button(this.bounds.left - 10, this.bounds.top, 10, this.bounds.height);
        ((Button)screen.addButton((class_364)this.scrollLeft)).onClick(sender -> this.scrollBy(-1)).getStyle().setText("<");
        this.scrollRight = new Button(this.bounds.left + this.bounds.width, this.bounds.top, 10, this.bounds.height);
        ((Button)screen.addButton((class_364)this.scrollRight)).onClick(sender -> this.scrollBy(1)).getStyle().setText(">");
        this.updateButtons();
    }

    private void scrollBy(int steps) {
        int pageSize;
        this.targetScrollPosition += steps;
        int skins = this.previewer.getRemote().getSkins().getProfileSkins(this.previewer.getActiveSkinType()).size();
        this.targetScrollPosition = skins < (pageSize = this.bounds.width / this.bounds.height) ? 0 : class_3532.method_15340((int)this.targetScrollPosition, (int)0, (int)skins);
    }

    private float getScrollOffset() {
        return -class_3532.method_16439((float)class_310.method_1551().method_1488(), (float)this.prevScrollPosition, (float)this.scrollPosition) * (float)this.bounds.height;
    }

    private void updateButtons() {
        List<ServerPlayerSkins.Skin> skins = this.previewer.getRemote().getSkins().getProfileSkins(this.previewer.getActiveSkinType());
        boolean hasContent = !skins.isEmpty();
        int pageSize = this.bounds.width / this.bounds.height;
        this.scrollLeft.setVisible(hasContent);
        this.scrollLeft.setEnabled(hasContent && this.scrollPosition > 0.0f);
        this.scrollRight.setVisible(hasContent);
        this.scrollRight.setEnabled(hasContent && skins.size() >= pageSize && (float)skins.size() > this.scrollPosition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(DummyPlayer player, class_332 context, int mouseX, int mouseY) {
        this.prevScrollPosition = this.scrollPosition;
        if ((float)this.targetScrollPosition != this.scrollPosition) {
            if (this.scrollPosition > (float)this.targetScrollPosition) {
                this.scrollPosition = this.scrollPosition - (float)this.targetScrollPosition < 0.2f ? (float)this.targetScrollPosition : (this.scrollPosition -= 0.1f);
            }
            if (this.scrollPosition < (float)this.targetScrollPosition) {
                this.scrollPosition = (float)this.targetScrollPosition - this.scrollPosition < 0.2f ? (float)this.targetScrollPosition : (this.scrollPosition += 0.1f);
            }
        }
        this.updateButtons();
        List<ServerPlayerSkins.Skin> skins = this.previewer.getRemote().getSkins().getProfileSkins(this.previewer.getActiveSkinType());
        if (skins.isEmpty()) {
            return;
        }
        int frameWidth = this.bounds.height;
        boolean sneaking = player.method_5715();
        if (sneaking) {
            player.method_5660(false);
        }
        class_4587 matrices = context.method_51448();
        matrices.method_22903();
        this.bounds.translate(matrices);
        matrices.method_46416(this.getScrollOffset(), 0.0f, 0.0f);
        context.method_25294(0, frameWidth, this.bounds.width, 0, -1610612736);
        int index = (int)((float)mouseX - ((float)this.bounds.left + this.getScrollOffset())) / frameWidth;
        boolean hovered = this.bounds.contains((double)mouseX, (double)mouseY);
        if (hovered && index < skins.size()) {
            context.method_25294(index * frameWidth, 0, (index + 1) * frameWidth, frameWidth, -1599427926);
        }
        try {
            for (int i = 0; i < skins.size(); ++i) {
                ServerPlayerSkins.Skin skin = skins.get(i);
                context.method_25294(i * frameWidth, 0, (i + 1) * frameWidth, frameWidth, -1610612736);
                if (skin.isReady()) {
                    player.setOverrideTextures(new PreviousServerPlayerSkins(skin));
                    float limbD = player.field_42108.method_48566();
                    int y = frameWidth;
                    if (hovered && i == index) {
                        y -= 3;
                        player.field_42108.method_48567(1.0f);
                    }
                    this.renderPlayerModel(matrices, player, i * frameWidth + frameWidth / 2, y, 13.0f);
                    player.field_42108.method_48567(limbD);
                }
                if (!skin.active()) continue;
                context.method_25294(i * frameWidth, 1, i * frameWidth + 1, frameWidth, -1);
                context.method_25294((i + 1) * frameWidth, 1, (i + 1) * frameWidth - 1, frameWidth, -1);
                context.method_25294(i * frameWidth, frameWidth - 1, (i + 1) * frameWidth, frameWidth, -1);
                context.method_25294(i * frameWidth, 0, (i + 1) * frameWidth, 1, -1);
            }
        }
        finally {
            player.setOverrideTextures(PlayerSkins.EMPTY);
            if (sneaking) {
                player.method_5660(true);
            }
        }
        matrices.method_22909();
    }

    public boolean mouseClicked(SkinUploader uploader, double mouseX, double mouseY, int button) {
        if (button != 0) {
            return false;
        }
        int frameWidth = this.bounds.height;
        if (!this.bounds.contains(mouseX, mouseY)) {
            return false;
        }
        int index = (int)((mouseX - (double)((float)this.bounds.left + this.getScrollOffset())) / (double)frameWidth);
        if (index >= this.previewer.getRemote().getSkins().getProfileSkins(this.previewer.getActiveSkinType()).size()) {
            return false;
        }
        GameGui.playSound((class_6880.class_6883)class_3417.field_15015);
        return uploader.getGateway().filter(gateway -> gateway.getProfile(this.previewer.getProfile()).getNow(Optional.empty()).filter(profile -> {
            SkinType type = this.previewer.getActiveSkinType();
            if (index >= 0 && index <= profile.getSkins(type).size()) {
                gateway.swapSkin(profile, type, index, uploader::setBannerMessage).thenRunAsync(uploader::scheduleReload, (Executor)this.client);
                return true;
            }
            return false;
        }).isPresent()).isPresent();
    }

    private void renderPlayerModel(class_4587 matrixStack, DummyPlayer thePlayer, float xPosition, float yPosition, float scale) {
        class_898 dispatcher = this.client.method_1561();
        if (dispatcher.method_3953((class_1297)thePlayer) == null) {
            HDSkins.LOGGER.warn("Entity " + thePlayer.toString() + " does not have a valid renderer. Did resource loading fail?");
            return;
        }
        thePlayer.method_5847(0.0f);
        thePlayer.method_36457(0.0f);
        float swingProgress = thePlayer.field_6251;
        thePlayer.field_6251 = 0.0f;
        class_4587 modelStack = RenderSystem.getModelViewStack();
        modelStack.method_22903();
        modelStack.method_46416(xPosition, yPosition, 1050.0f);
        modelStack.method_22905(1.0f, 1.0f, -1.0f);
        RenderSystem.applyModelViewMatrix();
        matrixStack.method_22903();
        matrixStack.method_46416(0.0f, 0.0f, 1000.0f);
        matrixStack.method_22905(scale, scale, scale);
        matrixStack.method_22907(class_7833.field_40714.rotationDegrees(15.0f));
        matrixStack.method_22907(class_7833.field_40718.rotationDegrees(180.0f));
        matrixStack.method_22907(class_7833.field_40716.rotationDegrees(220.0f));
        class_308.method_34742();
        class_4597.class_4598 immediate = this.client.method_22940().method_23000();
        this.renderPlayerEntity(matrixStack, thePlayer, (class_4597)immediate, dispatcher);
        immediate.method_22993();
        matrixStack.method_22909();
        modelStack.method_22909();
        RenderSystem.applyModelViewMatrix();
        class_308.method_24211();
        thePlayer.field_6251 = swingProgress;
    }

    protected void renderPlayerEntity(class_4587 matrixStack, DummyPlayer thePlayer, class_4597 renderContext, class_898 dispatcher) {
        matrixStack.method_22903();
        matrixStack.method_22904(0.001, 0.0, 0.001);
        DummyWorld.fillWith(class_2246.field_10124.method_9564());
        if (thePlayer.method_18798().field_1352 >= 100.0) {
            thePlayer.method_5762(-100.0, 0.0, 0.0);
        }
        class_1297 camera = this.client.method_1560();
        this.client.method_1504((class_1297)thePlayer);
        float y = thePlayer.method_5715() ? -0.125f : 0.0f;
        dispatcher.method_3954((class_1297)thePlayer, 0.0, (double)y, 0.0, 0.0f, 1.0f, matrixStack, renderContext, 0xF000F0);
        this.client.method_1504(camera);
        matrixStack.method_22909();
    }
}

