/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.hdskins.client.gui;

import com.minelittlepony.hdskins.client.HDSkins;
import com.minelittlepony.hdskins.client.gui.CarouselStatusLabel;
import com.minelittlepony.hdskins.client.gui.DualCarouselWidget;
import com.minelittlepony.hdskins.client.gui.player.DummyPlayer;
import com.minelittlepony.hdskins.client.gui.player.skins.LocalPlayerSkins;
import com.minelittlepony.hdskins.client.gui.player.skins.ServerPlayerSkins;
import com.minelittlepony.hdskins.profile.SkinCallback;
import com.minelittlepony.hdskins.profile.SkinType;
import com.minelittlepony.hdskins.server.Feature;
import com.minelittlepony.hdskins.server.Gateway;
import com.minelittlepony.hdskins.server.SkinServer;
import com.minelittlepony.hdskins.server.SkinUpload;
import com.minelittlepony.hdskins.server.TexturePayload;
import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5244;

public class SkinUploader
implements Closeable,
CarouselStatusLabel {
    public static final class_2561 STATUS_OK = class_5244.field_39003;
    public static final class_2561 STATUS_NO_SERVER = class_2561.method_43471((String)"hdskins.error.noserver");
    public static final class_2561 STATUS_OFFLINE = class_2561.method_43471((String)"hdskins.error.offline");
    public static final class_2561 STATUS_SESSION = class_2561.method_43471((String)"hdskins.error.session.short");
    public static final class_2561 ERR_SESSION = class_2561.method_43471((String)"hdskins.error.session");
    public static final class_2561 STATUS_MOJANG = class_2561.method_43471((String)"hdskins.error.mojang");
    public static final class_2561 STATUS_BUSY = class_2561.method_43471((String)"hdskins.status.busy");
    public static final String ERR_MOJANG_WAIT = "hdskins.error.mojang.wait";
    public static final class_2561 STATUS_FETCH = class_2561.method_43471((String)"hdskins.fetch");
    private class_2561 bannerMessage = STATUS_OK;
    private Map<String, String> skinMetadata = new HashMap<String, String>();
    private volatile boolean pendingRefresh = false;
    private int reloadCounter = 0;
    private int retries = 1;
    private final DualCarouselWidget previewer;
    private final Iterator<Gateway> gateways;
    private Optional<Gateway> gateway;
    private SkinCallback loadListener = SkinCallback.NOOP;
    private Consumer<SkinType> skinTypeChangedListener = t -> {};
    private final SkinUpload.Session session;

    public SkinUploader(Iterator<Gateway> gateways, DualCarouselWidget previewer, SkinUpload.Session session) {
        this.previewer = previewer;
        this.gateways = gateways;
        this.session = session;
        this.skinMetadata.put("model", "default");
        this.cycleGateway();
    }

    public void addSkinLoadedEventListener(SkinCallback listener) {
        this.loadListener = this.loadListener.andThen(listener);
    }

    public void addSkinTypeChangedEventListener(Consumer<SkinType> listener) {
        this.skinTypeChangedListener = this.skinTypeChangedListener.andThen(listener);
    }

    public Map<String, String> getMetadata() {
        return this.skinMetadata;
    }

    public void cycleGateway() {
        if (this.gateways.hasNext()) {
            this.gateway = Optional.ofNullable(this.gateways.next());
            this.setSkinType(this.gateway.flatMap(g -> g.getServer().supportsSkinType(this.previewer.getActiveSkinType()) ? Optional.of(this.previewer.getActiveSkinType()) : this.getSupportedSkinTypes().findFirst()).orElse(SkinType.UNKNOWN));
            this.scheduleReload();
        } else {
            this.setBannerMessage(STATUS_NO_SERVER);
        }
    }

    public Optional<Gateway> getGateway() {
        return this.gateway;
    }

    public String getGatewayText() {
        return this.gateway.map(Gateway::getServer).map(Object::toString).orElse("");
    }

    public Set<Feature> getFeatures() {
        return this.gateway.map(Gateway::getServer).map(SkinServer::getFeatures).orElse(Set.of());
    }

    public Stream<SkinType> getSupportedSkinTypes() {
        return this.gateway.stream().flatMap(Gateway::getSupportedSkinTypes);
    }

    public void setSkinType(SkinType type) {
        if (type == this.previewer.getActiveSkinType()) {
            return;
        }
        this.previewer.setSkinType(type);
        this.skinTypeChangedListener.accept(type);
    }

    public boolean isThrottled() {
        return this.gateway.filter(Gateway::isThrottled).isPresent();
    }

    public int getRetries() {
        return this.retries;
    }

    private boolean isOnline() {
        return this.gateway.filter(Gateway::isOnline).isPresent() && this.getBannerMessage() != ERR_SESSION;
    }

    public boolean isBusy() {
        return this.gateway.filter(Gateway::isBusy).isPresent();
    }

    private boolean isSkinOperationsBlocked() {
        return !this.isOnline() || this.hasBannerMessage() || this.isBusy();
    }

    public boolean canUpload(SkinType type) {
        return this.getFeatures().contains((Object)Feature.UPLOAD_USER_SKIN) && !this.isSkinOperationsBlocked() && ((LocalPlayerSkins.LocalTexture)this.previewer.getLocal().getSkins().get(type)).isReady();
    }

    public boolean canClear(SkinType type) {
        return this.getFeatures().contains((Object)Feature.DELETE_USER_SKIN) && !this.isSkinOperationsBlocked() && ((ServerPlayerSkins.RemoteTexture)this.previewer.getRemote().getSkins().get(type)).isReady();
    }

    public boolean canClearAny() {
        return this.getFeatures().contains((Object)Feature.DELETE_USER_SKIN) && !this.isSkinOperationsBlocked() && this.previewer.getRemote().getSkins().hasAny();
    }

    public boolean hasBannerMessage() {
        return this.bannerMessage != STATUS_OK;
    }

    public class_2561 getBannerMessage() {
        return this.bannerMessage;
    }

    public void setBannerMessage(class_2561 er) {
        this.bannerMessage = er;
    }

    @Override
    public boolean hasStatus() {
        return this.getStatus() != STATUS_OK;
    }

    private class_2561 getStatus() {
        if (this.isBusy()) {
            return STATUS_BUSY;
        }
        if (this.gateway.isEmpty()) {
            return STATUS_OFFLINE;
        }
        if (this.isThrottled()) {
            return STATUS_MOJANG;
        }
        if (!this.isOnline()) {
            return STATUS_OFFLINE;
        }
        if (this.session.hasFailedValidation()) {
            return STATUS_SESSION;
        }
        return STATUS_OK;
    }

    @Override
    public List<class_2561> getStatusLines() {
        class_2561 status = this.getStatus();
        if (status == STATUS_MOJANG) {
            return List.of(status, class_2561.method_43469((String)ERR_MOJANG_WAIT, (Object[])new Object[]{this.getRetries()}));
        }
        return List.of(status);
    }

    @Override
    public int getLabelColor(class_2561 status) {
        return this.isThrottled() || status == STATUS_SESSION || status == STATUS_OFFLINE ? 0xFF5555 : 0xFFFFFF;
    }

    public void setMetadataField(String field, String value) {
        this.previewer.getLocal().getSkins().close();
        this.skinMetadata.put(field, value);
    }

    public String getMetadataField(String field) {
        return this.skinMetadata.getOrDefault(field, "");
    }

    public boolean tryClearStatus() {
        if (!this.hasBannerMessage() || !this.isBusy() && !this.isThrottled()) {
            this.setBannerMessage(STATUS_OK);
            return true;
        }
        return false;
    }

    public CompletableFuture<Void> uploadSkin(class_2561 statusMsg, SkinUpload payload) {
        this.setBannerMessage(statusMsg);
        return this.gateway.map(g -> g.uploadSkin(payload, this::setBannerMessage)).map(future -> future.thenRunAsync(this::scheduleReload, (Executor)class_310.method_1551())).orElseGet(() -> CompletableFuture.failedFuture(new IOException("No gateway"))).whenComplete((o, t) -> {
            if (t != null) {
                HDSkins.LOGGER.fatal("Exception caught whilst uploading skin", t);
            }
        });
    }

    public void scheduleReload() {
        this.pendingRefresh = true;
    }

    protected void fetchRemote() {
        this.pendingRefresh = false;
        this.gateway.ifPresent(gateway -> ((CompletableFuture)gateway.fetchSkins(this.previewer.getProfile(), this.session, this::setBannerMessage).thenAcceptAsync(textures -> {
            ServerPlayerSkins skins = this.previewer.getRemote().getSkins();
            skins.loadTextures((TexturePayload)textures, this.loadListener);
            gateway.getProfile(this.previewer.getProfile()).thenAccept(serverProfile -> skins.loadProfile((Optional<SkinServer.SkinServerProfile<?>>)serverProfile));
        }, (Executor)class_310.method_1551())).handleAsync((a, throwable) -> {
            if (throwable == null) {
                this.retries = 1;
            }
            return a;
        }, (Executor)class_310.method_1551()));
    }

    @Override
    public void close() throws IOException {
        this.previewer.close();
    }

    public void update() {
        this.previewer.apply(DummyPlayer::updateModel);
        if (this.isThrottled()) {
            this.reloadCounter = (this.reloadCounter + 1) % (200 * this.retries);
            if (this.reloadCounter == 0) {
                ++this.retries;
                this.fetchRemote();
            }
        } else if (this.pendingRefresh) {
            this.fetchRemote();
        }
    }
}

