/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.hdskins.client.gui.filesystem;

import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class WatchedFile {
    private static final Logger logger = LogManager.getLogger();
    private final Object locker = new Object();
    @Nullable
    private Path pending;
    @Nullable
    private Path path;
    @Nullable
    private WatchKey key;
    private Consumer<Path> onChange;
    private Runnable onRemove;

    public WatchedFile(Consumer<Path> change, Runnable remove) {
        this.onChange = change;
        this.onRemove = remove;
    }

    public boolean isPending() {
        return this.pending != null;
    }

    public boolean isSet() {
        return this.path != null;
    }

    @Nullable
    public URI toUri() {
        return this.path == null ? null : this.path.toUri();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(Path newFile) {
        this.onRemove.run();
        Object object = this.locker;
        synchronized (object) {
            this.pending = newFile;
            try {
                this.clearKey();
                WatchService service = newFile.getParent().getFileSystem().newWatchService();
                this.key = newFile.getParent().register(service, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE);
            }
            catch (IOException e) {
                this.clearKey();
                logger.error((Object)e);
            }
        }
    }

    private void clearKey() {
        if (this.key != null) {
            this.key.cancel();
            this.key = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        Object object = this.locker;
        synchronized (object) {
            if (this.key != null && this.key.isValid()) {
                for (WatchEvent<?> ev : this.key.pollEvents()) {
                    Object context = ev.context();
                    WatchEvent.Kind<?> kind = ev.kind();
                    if (!(context instanceof Path) || !(this.pending == null ? this.path : this.pending).endsWith((Path)context)) continue;
                    if (StandardWatchEventKinds.ENTRY_DELETE.equals(kind)) {
                        this.pending = null;
                        this.clearKey();
                        this.onRemove.run();
                        break;
                    }
                    if (!StandardWatchEventKinds.ENTRY_MODIFY.equals(kind) || this.pending != null) continue;
                    this.pending = this.path;
                }
            }
            if (this.pending != null && Files.exists(this.pending, new LinkOption[0])) {
                this.path = this.pending;
                this.pending = null;
                this.onChange.accept(this.path);
            }
        }
    }
}

