/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.hdskins.client.gui.filesystem.integrated;

import com.minelittlepony.common.client.gui.element.Button;
import com.minelittlepony.common.util.GamePaths;
import com.minelittlepony.hdskins.client.gui.ConfirmationScreen;
import com.minelittlepony.hdskins.client.gui.filesystem.FileDialog;
import com.minelittlepony.hdskins.client.gui.filesystem.integrated.FileSelectorScreen;
import com.minelittlepony.hdskins.util.net.FileTypes;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.minecraft.class_2561;
import net.minecraft.class_364;
import net.minecraft.class_437;

public class FileSaverScreen
extends FileSelectorScreen {
    public static final class_2561 SAVE_OVERWRITE = class_2561.method_43471((String)"hdskins.save.overwrite");
    public static final class_2561 SAVE_READONLY = class_2561.method_43471((String)"hdskins.save.readonly");
    private Button saveBtn;
    private String savingFileName;

    public FileSaverScreen(String title, String filename) {
        super(title);
        this.savingFileName = filename;
        this.currentDirectory = Files.isDirectory(this.currentDirectory, new LinkOption[0]) ? this.currentDirectory.resolve(this.savingFileName) : this.currentDirectory.getParent().resolve(this.savingFileName);
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        this.saveBtn = new Button(this.field_22789 / 2 - 50, this.field_22790 - 25, 100, 20);
        ((Button)this.addButton((class_364)this.saveBtn)).onClick(p -> {
            try {
                this.currentDirectory = Paths.get(this.textInput.method_1882(), new String[0]);
                if (Files.exists(this.currentDirectory, new LinkOption[0])) {
                    this.field_22787.method_1507((class_437)new ConfirmationScreen((class_437)this, SAVE_OVERWRITE, () -> this.navigateTo(this.currentDirectory)));
                } else {
                    this.onFileSelected(this.currentDirectory);
                }
            }
            catch (InvalidPathException invalidPathException) {
                // empty catch block
            }
        }).getStyle().setText("hdskins.directory.save");
        this.textInput.method_1863(this::updateButtonStates);
        this.updateButtonStates(this.textInput.method_1882());
    }

    @Override
    public FileDialog filter(String extension, String description) {
        this.currentDirectory = FileTypes.changeExtension(this.currentDirectory, extension);
        return super.filter(extension, description);
    }

    protected void updateButtonStates(String value) {
        try {
            Path selection = Paths.get(value.trim(), new String[0]);
            this.saveBtn.setEnabled(selection != null && !Files.isDirectory(selection, new LinkOption[0]));
        }
        catch (InvalidPathException invalidPathException) {
            // empty catch block
        }
    }

    @Override
    protected void onPathSelected(FileSelectorScreen.PathButton sender) {
        if (Files.isDirectory(sender.path, new LinkOption[0])) {
            super.onPathSelected(sender);
        } else {
            this.filesList.buttons().forEach(p -> ((FileSelectorScreen.PathButton)((Object)p)).clearFocus());
            this.method_20086((class_364)sender);
            this.saveBtn.setEnabled(true);
            this.textInput.method_1852(sender.path.toString());
        }
    }

    @Override
    protected void onFileSelected(Path fileLocation) {
        Path parent = fileLocation.getParent();
        Path name = fileLocation.getFileName();
        if (parent != null && name != null && !Files.isWritable(parent)) {
            this.field_22787.method_1507((class_437)new ConfirmationScreen((class_437)this, SAVE_READONLY, () -> this.onDirectorySelected(GamePaths.getGameDirectory().resolve(name))));
            return;
        }
        super.onFileSelected(fileLocation);
    }

    @Override
    public void navigateTo(Path path) {
        Path userInput = Paths.get(this.textInput.method_1882(), new String[0]);
        String fileName = "";
        if (userInput != null && (userInput = userInput.getFileName()) != null) {
            fileName = userInput.getFileName().toString().trim();
        }
        if (fileName.isEmpty()) {
            fileName = this.savingFileName;
        } else {
            this.savingFileName = fileName;
        }
        if (path != null && Files.isDirectory(path, new LinkOption[0])) {
            if (!Files.isDirectory(this.currentDirectory, new LinkOption[0]) && path.equals(this.currentDirectory.getParent()) && path.getParent() != null) {
                path = path.getParent();
            }
            path = path.resolve(this.savingFileName);
            if (!this.extensionFilter.isEmpty()) {
                path = FileTypes.changeExtension(path, this.extensionFilter);
            }
            path = path.toAbsolutePath();
            this.onDirectorySelected(path);
        } else {
            super.navigateTo(path);
        }
    }
}

