/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.hdskins.client.gui.filesystem.os;

import com.minelittlepony.hdskins.client.gui.filesystem.FileDialog;
import com.minelittlepony.hdskins.client.gui.filesystem.FileDialogs;
import com.minelittlepony.hdskins.client.gui.filesystem.os.AbstractNativeFileDialog;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.util.tinyfd.TinyFileDialogs;

public final class NativeFileDialogs
implements FileDialogs {
    @Override
    public FileDialog open(final String title) {
        return new AbstractNativeFileDialog(){

            @Override
            @Nullable
            protected String runFileDialog() {
                return TinyFileDialogs.tinyfd_openFileDialog((CharSequence)title, (CharSequence)this.currentDirectory.toString(), (PointerBuffer)NativeFileDialogs.getFilterBuffer(this.extensionFilter), (CharSequence)this.filterMessage, (boolean)false);
            }
        };
    }

    @Override
    public FileDialog save(final String title, final String filename) {
        return new AbstractNativeFileDialog(){

            @Override
            @Nullable
            protected String runFileDialog() {
                this.currentDirectory = Files.isDirectory(this.currentDirectory, new LinkOption[0]) ? this.currentDirectory.resolve(filename) : this.currentDirectory.resolveSibling(filename);
                return TinyFileDialogs.tinyfd_saveFileDialog((CharSequence)title, (CharSequence)this.currentDirectory.toString(), (PointerBuffer)NativeFileDialogs.getFilterBuffer(this.extensionFilter), (CharSequence)this.filterMessage);
            }
        };
    }

    private static PointerBuffer getFilterBuffer(@Nullable String filter) {
        if (filter == null) {
            return null;
        }
        return PointerBuffer.create((ByteBuffer)ByteBuffer.wrap(filter.getBytes(StandardCharsets.UTF_8)));
    }
}

