/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.hdskins.client.gui.player.skins;

import com.minelittlepony.hdskins.client.gui.player.skins.PlayerSkins;
import com.minelittlepony.hdskins.client.resources.HDPlayerSkinTexture;
import com.minelittlepony.hdskins.client.resources.Texture;
import com.minelittlepony.hdskins.client.resources.TextureLoader;
import com.minelittlepony.hdskins.profile.SkinType;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_1011;
import net.minecraft.class_1044;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public class LocalPlayerSkins
extends PlayerSkins<LocalTexture> {
    public LocalPlayerSkins(PlayerSkins.Posture posture) {
        super(posture);
    }

    @Override
    protected LocalTexture createTexture(SkinType type, Supplier<class_2960> blank) {
        return new LocalTexture(type, blank);
    }

    @Override
    public String getSkinVariant() {
        return this.getPosture().getSkinVariant().map(PlayerSkins.Posture.SkinVariant::name).orElse("default");
    }

    @Override
    protected boolean isProvided(SkinType type) {
        return this.getPosture().getActiveSkinType() == type;
    }

    public class LocalTexture
    implements PlayerSkins.PlayerSkin {
        private final SkinType type;
        private final class_2960 id;
        private final Supplier<class_2960> defaultTexture;
        private Optional<Texture.MemoryTexture> local = Optional.empty();

        public LocalTexture(SkinType type, Supplier<class_2960> blank) {
            this.type = type;
            this.id = new class_2960("hdskins", "generated_preview/" + LocalPlayerSkins.this.getPosture().getProfile().getId().toString() + "/" + type.getPathName());
            this.defaultTexture = blank;
        }

        @Override
        public class_2960 getId() {
            return this.isReady() ? this.id : this.defaultTexture.get();
        }

        public void setLocal(Path file) throws IOException {
            this.local.ifPresent(class_1044::close);
            try (InputStream input = Files.newInputStream(file, new OpenOption[0]);){
                Texture.MemoryTexture image = new Texture.MemoryTexture(this.type != SkinType.SKIN ? class_1011.method_4309((InputStream)input) : HDPlayerSkinTexture.filterPlayerSkins(class_1011.method_4309((InputStream)input), TextureLoader.Exclusion.NULL), this.id);
                class_310.method_1551().method_1531().method_4616(this.id, (class_1044)image);
                this.local = Optional.of(image);
            }
        }

        @Override
        public boolean isReady() {
            return this.local.filter(Texture::isLoaded).isPresent();
        }

        @Override
        public void close() {
            this.local.ifPresent(class_1044::close);
            this.local = Optional.empty();
        }
    }
}

