/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.hdskins.client.gui.player.skins;

import com.minelittlepony.hdskins.client.gui.player.skins.PlayerSkins;
import com.minelittlepony.hdskins.client.resources.DynamicTextures;
import com.minelittlepony.hdskins.client.resources.Texture;
import com.minelittlepony.hdskins.client.resources.TextureLoader;
import com.minelittlepony.hdskins.profile.SkinCallback;
import com.minelittlepony.hdskins.profile.SkinType;
import com.minelittlepony.hdskins.server.SkinServer;
import com.minelittlepony.hdskins.server.TexturePayload;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.class_1044;
import net.minecraft.class_1068;
import net.minecraft.class_2960;

public class ServerPlayerSkins
extends PlayerSkins<RemoteTexture> {
    private Optional<DynamicTextures> textureManager = Optional.empty();
    private Optional<SkinServer.SkinServerProfile<?>> profile = Optional.empty();
    private final Map<SkinType, List<Skin>> skinLists = new HashMap<SkinType, List<Skin>>();

    public ServerPlayerSkins(PlayerSkins.Posture posture) {
        super(posture);
    }

    public void loadProfile(Optional<SkinServer.SkinServerProfile<?>> profile) {
        this.profile = profile;
        this.skinLists.clear();
    }

    public void loadTextures(TexturePayload payload, SkinCallback loadCallback) {
        super.close();
        this.textureManager = Optional.of(new DynamicTextures(payload, loadCallback));
    }

    @Override
    protected RemoteTexture createTexture(SkinType type, Supplier<class_2960> blank) {
        return new RemoteTexture(blank, this.textureManager.flatMap(tpm -> tpm.loadTexture(type, (class_2960)blank.get())));
    }

    public List<Skin> getProfileSkins(SkinType type) {
        return this.skinLists.computeIfAbsent(type, t -> this.profile.map(profile -> profile.getSkins((SkinType)t).stream().map(skin -> {
            String model = skin.getModel();
            String uri = skin.getUri();
            String hash = String.valueOf(uri.hashCode());
            class_2960 id = new class_2960("hdskins", String.format("dynamic/%s/%s", type.getId().method_12832(), hash));
            Supplier<class_2960> blank = () -> this.getPosture().getDefaultSkin((SkinType)t, model);
            return new Skin(blank, Optional.of(TextureLoader.loadTexture(id, Texture.UriTexture.create(id, DynamicTextures.createTempFile(hash), uri, type, model, blank.get(), null))), skin.isActive());
        }).toList()).orElse(List.of()));
    }

    @Override
    public void close() {
        this.textureManager = Optional.empty();
        this.profile = Optional.empty();
        this.skinLists.clear();
        super.close();
    }

    @Override
    public String getSkinVariant() {
        return this.textureManager.flatMap(manager -> manager.getTextureMetadata(SkinType.SKIN)).map(metadata -> metadata.getMetadata("model")).orElseGet(() -> class_1068.method_4647((UUID)this.getPosture().getProfile().getId()));
    }

    @Override
    protected boolean isProvided(SkinType type) {
        return ((RemoteTexture)this.get(type)).isReady() || this.textureManager.flatMap(manager -> manager.getTextureMetadata(type)).isPresent();
    }

    public record RemoteTexture(Supplier<class_2960> blank, Optional<Texture.UriTexture> texture) implements PlayerSkins.PlayerSkin
    {
        @Override
        public class_2960 getId() {
            return this.texture.filter(Texture::isLoaded).map(Texture::getId).orElseGet(this.blank);
        }

        @Override
        public boolean isReady() {
            return this.texture.filter(Texture::isLoaded).isPresent();
        }

        @Override
        public void close() {
            this.texture.ifPresent(class_1044::close);
        }
    }

    public record Skin(Supplier<class_2960> blank, Optional<Texture.UriTexture> texture, boolean active) implements PlayerSkins.PlayerSkin
    {
        @Override
        public class_2960 getId() {
            return this.texture != null ? this.blank.get() : this.texture.filter(Texture::isLoaded).map(Texture::getId).orElseGet(this.blank);
        }

        @Override
        public boolean isReady() {
            return this.texture.filter(Texture::isLoaded).isPresent();
        }

        @Override
        public void close() {
            this.texture.ifPresent(class_1044::close);
        }
    }
}

