/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.hdskins.client.profile;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.minelittlepony.hdskins.client.HDSkins;
import com.minelittlepony.hdskins.profile.ProfileUtils;
import com.minelittlepony.hdskins.profile.SkinType;
import com.minelittlepony.hdskins.server.Feature;
import com.minelittlepony.hdskins.server.Gateway;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.exceptions.AuthenticationException;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import net.minecraft.class_156;

class ProfileCache {
    private LoadingCache<GameProfile, CompletableFuture<Map<SkinType, MinecraftProfileTexture>>> profiles = CacheBuilder.newBuilder().expireAfterAccess(15L, TimeUnit.SECONDS).build(CacheLoader.from(this::fetchOnlineData));
    private final HDSkins hd;

    ProfileCache(HDSkins hd) {
        this.hd = hd;
    }

    private CompletableFuture<Map<SkinType, MinecraftProfileTexture>> fetchOnlineData(GameProfile profile) {
        if (profile.getId() == null) {
            return CompletableFuture.completedFuture(Collections.emptyMap());
        }
        return CompletableFuture.supplyAsync(() -> {
            Set requestedSkinTypes = SkinType.REGISTRY.method_10220().filter(SkinType::isKnown).collect(Collectors.toSet());
            HashMap textureMap = new HashMap();
            for (Gateway gateway : this.hd.getSkinServerList().getSkinServers()) {
                try {
                    if (gateway.getServer().getFeatures().contains((Object)Feature.SYNTHETIC)) continue;
                    gateway.getServer().loadSkins(profile).getTextures().forEach((type, texture) -> {
                        if (requestedSkinTypes.remove(type)) {
                            textureMap.putIfAbsent(type, texture);
                        }
                    });
                    if (!requestedSkinTypes.isEmpty()) continue;
                    break;
                }
                catch (AuthenticationException | IOException e) {
                    HDSkins.LOGGER.trace((Object)e);
                }
            }
            return textureMap;
        }, class_156.method_18349());
    }

    public CompletableFuture<Map<SkinType, MinecraftProfileTexture>> loadProfile(GameProfile profile) {
        return this.hd.getSkinServerList().getEmbeddedTextures(profile).findFirst().map(CompletableFuture::completedFuture).orElseGet(() -> (CompletableFuture)this.profiles.getUnchecked((Object)ProfileUtils.fixGameProfile(profile)));
    }

    public void clear() {
        this.profiles.invalidateAll();
    }
}

