/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.hdskins.client.profile;

import com.minelittlepony.common.util.GamePaths;
import com.minelittlepony.hdskins.client.HDSkins;
import com.minelittlepony.hdskins.client.SkinCacheClearCallback;
import com.minelittlepony.hdskins.client.profile.ProfileCache;
import com.minelittlepony.hdskins.client.resources.HDPlayerSkinTexture;
import com.minelittlepony.hdskins.client.resources.TextureLoader;
import com.minelittlepony.hdskins.profile.SkinCallback;
import com.minelittlepony.hdskins.profile.SkinType;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import net.minecraft.class_1044;
import net.minecraft.class_1068;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public class ProfileRepository {
    private final ProfileCache cache;

    public ProfileRepository(HDSkins hd) {
        this.cache = new ProfileCache(hd);
    }

    public void fetchSkins(GameProfile profile, SkinCallback callback) {
        this.cache.loadProfile(profile).thenAcceptAsync(m -> m.forEach((type, texture) -> this.loadTexture((SkinType)type, (MinecraftProfileTexture)texture, callback)), (Executor)class_156.method_18349());
    }

    public Map<SkinType, class_2960> getTextures(GameProfile profile) {
        return this.loadSkinMap(this.cache.loadProfile(profile).getNow(Collections.emptyMap()));
    }

    private Map<SkinType, class_2960> loadSkinMap(Map<SkinType, MinecraftProfileTexture> textureMap) {
        return textureMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> this.loadTexture((SkinType)e.getKey(), (MinecraftProfileTexture)e.getValue(), SkinCallback.NOOP)));
    }

    private class_2960 loadTexture(SkinType type, MinecraftProfileTexture texture, SkinCallback callback) {
        class_2960 resource = new class_2960("hdskins", type.getPathName() + "/" + texture.getHash());
        class_1044 texObj = class_310.method_1551().method_1531().method_34590(resource, null);
        if (texObj != null) {
            callback.onSkinAvailable(type, resource, texture);
        } else {
            TextureLoader.loadTexture(resource, new HDPlayerSkinTexture(this.getCachedSkinLocation(type, texture).toFile(), texture.getUrl(), type, class_1068.method_4649(), () -> callback.onSkinAvailable(type, resource, texture)));
        }
        return resource;
    }

    private Path getCachedSkinLocation(SkinType type, MinecraftProfileTexture texture) {
        Path location = ProfileRepository.getHDSkinsCache().resolve(type.getPathName()).resolve(texture.getHash().substring(0, 2)).resolve(texture.getHash());
        try {
            Files.createDirectories(location.getParent(), new FileAttribute[0]);
            return location;
        }
        catch (IOException e) {
            HDSkins.LOGGER.error("Could not create cache location for texture: {}", (Object)texture.getHash(), (Object)e);
            return null;
        }
    }

    public void clear() {
        HDSkins.LOGGER.info("Clearing local player skin cache");
        this.cache.clear();
        try {
            Path cachePath = ProfileRepository.getHDSkinsCache();
            if (Files.exists(cachePath, new LinkOption[0])) {
                Files.walkFileTree(cachePath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        Files.delete(file);
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                        Files.delete(dir);
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
        }
        catch (IOException e) {
            HDSkins.LOGGER.warn("Could not remove cache folder", (Throwable)e);
        }
        ((SkinCacheClearCallback)SkinCacheClearCallback.EVENT.invoker()).onSkinCacheCleared();
    }

    private static Path getHDSkinsCache() {
        return GamePaths.getAssetsDirectory().resolve("hd");
    }
}

