/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.hdskins.client.resources;

import com.minelittlepony.hdskins.client.resources.Texture;
import com.minelittlepony.hdskins.client.resources.TextureLoader;
import com.minelittlepony.hdskins.profile.SkinCallback;
import com.minelittlepony.hdskins.profile.SkinType;
import com.minelittlepony.hdskins.server.TexturePayload;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class DynamicTextures {
    private final TexturePayload payload;
    private final SkinCallback loadCallback;

    public DynamicTextures(TexturePayload payload, SkinCallback loadCallback) {
        this.payload = payload;
        this.loadCallback = loadCallback;
    }

    public Optional<MinecraftProfileTexture> getTextureMetadata(SkinType type) {
        return this.payload.getTexture(type);
    }

    public Optional<Texture.UriTexture> loadTexture(SkinType type, class_2960 def) {
        return this.getTextureMetadata(type).map(texture -> {
            class_2960 id = new class_2960("hdskins", String.format("dynamic/%s/%s", type.getId().method_12832(), texture.getHash()));
            return TextureLoader.loadTexture(id, Texture.UriTexture.create(id, DynamicTextures.createTempFile(texture.getHash()), texture.getUrl(), type, texture.getMetadata("model"), def, () -> this.loadCallback.onSkinAvailable(type, id, (MinecraftProfileTexture)texture)));
        });
    }

    @Nullable
    public static File createTempFile(String filename) {
        try {
            File f = Files.createTempFile(filename, "skin-preview", new FileAttribute[0]).toFile();
            f.delete();
            return f;
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

