/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.hdskins.client.resources;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.minelittlepony.common.util.registry.RegistryTypeAdapter;
import com.minelittlepony.common.util.settings.ToStringAdapter;
import com.minelittlepony.hdskins.client.HDSkins;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class EquipmentList
extends class_4309
implements IdentifiableResourceReloadListener {
    private static final class_2960 EQUIPMENT = new class_2960("hdskins", "skins/equipment");
    private static final class_2960 EMPTY = new class_2960("hdskins", "empty");
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(class_2960.class, (Object)new ToStringAdapter(class_2960::new)).registerTypeAdapter(class_1792.class, (Object)RegistryTypeAdapter.of((class_2378)class_7923.field_41178)).registerTypeAdapter(class_3414.class, (Object)RegistryTypeAdapter.of((class_2378)class_7923.field_41172)).registerTypeAdapter(class_1304.class, (Object)new ToStringAdapter(class_1304::method_5923, s -> class_1304.method_5924((String)s.toLowerCase()))).create();
    private EquipmentSet emptySet = new EquipmentSet(EMPTY);
    private final List<EquipmentSet> equipmentSets = Lists.newArrayList((Object[])new EquipmentSet[]{this.emptySet});

    public EquipmentList() {
        super(GSON, "hd_skins_equipment");
    }

    public class_2960 getFabricId() {
        return EQUIPMENT;
    }

    protected void apply(Map<class_2960, JsonElement> resources, class_3300 manager, class_3695 profiler) {
        this.emptySet = new EquipmentSet(EMPTY);
        this.equipmentSets.clear();
        HDSkins.LOGGER.info("Found {} potential player equipment sets", (Object)resources.size());
        for (Map.Entry<class_2960, JsonElement> entry : resources.entrySet()) {
            try {
                EquipmentSet set = (EquipmentSet)GSON.fromJson(entry.getValue(), EquipmentSet.class);
                if (set == null) continue;
                set.id = entry.getKey();
                this.equipmentSets.add(set);
                if (!"empty".equals(entry.getKey().method_12832())) continue;
                this.emptySet = set;
            }
            catch (JsonParseException | IllegalArgumentException e) {
                HDSkins.LOGGER.error("Unable to read {} from resource packs", (Object)EQUIPMENT, (Object)e);
            }
        }
        HDSkins.LOGGER.info("Loaded {} player equipment sets", (Object)this.equipmentSets.size());
        if (this.equipmentSets.isEmpty()) {
            this.equipmentSets.add(this.emptySet);
        }
    }

    public EquipmentSet getDefault() {
        return this.emptySet;
    }

    public Stream<EquipmentSet> getValues() {
        return this.equipmentSets.stream();
    }

    public static class EquipmentSet {
        private Map<class_1304, class_1792> equipment = new EnumMap<class_1304, class_1792>(class_1304.class);
        private class_1792 item;
        @Nullable
        private class_3414 sound;
        private transient class_2960 id;

        EquipmentSet(class_2960 id) {
            this.id = id;
        }

        public void apply(class_1309 entity) {
            for (class_1304 slot : class_1304.values()) {
                entity.method_5673(slot, this.getStack(slot));
            }
        }

        public class_3414 getSound() {
            return this.sound == null ? class_3417.field_14883 : this.sound;
        }

        public class_1799 getStack(class_1304 slot) {
            return this.equipment.getOrDefault(slot, class_1802.field_8162).method_7854();
        }

        public class_1799 getStack() {
            return new class_1799((class_1935)this.item);
        }

        public class_2960 getId() {
            return this.id;
        }

        public class_2561 getTooltip() {
            return class_2561.method_43469((String)"hdskins.equipment", (Object[])new Object[]{class_2561.method_43471((String)("hdskins.equipment." + this.id.method_12832()))});
        }
    }
}

