/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.hdskins.client.resources;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.minelittlepony.hdskins.client.resources.TextureLoader;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_1011;
import net.minecraft.class_1068;
import net.minecraft.class_2960;
import net.minecraft.class_5253;

public interface NativeImageFilters {
    public static final NativeImageFilters GREYSCALE = NativeImageFilters.create("default_player_skin", color -> {
        int a = class_5253.class_8045.method_48342((int)color);
        float r = (float)class_5253.class_8045.method_48345((int)color) / 255.0f;
        float g = (float)class_5253.class_8045.method_48346((int)color) / 255.0f;
        float b = (float)class_5253.class_8045.method_48347((int)color) / 255.0f;
        int brightness = (int)((0.2126f * r + 0.7152f * g + 0.0722f * b) * 255.0f);
        return class_5253.class_8045.method_48344((int)a, (int)brightness, (int)brightness, (int)brightness);
    });
    public static final NativeImageFilters REDUCE_ALPHA = NativeImageFilters.create("default_player_skin_half_alpha", color -> {
        int a = Math.min(class_5253.class_8045.method_48342((int)color), 48);
        return color & 0xFFFFFF | a << 24;
    });

    public static NativeImageFilters create(String name, Int2IntFunction pixelTransformation) {
        TextureLoader loader = new TextureLoader(name, (image, exclusion) -> {
            class_1011 copy = new class_1011(image.method_4318(), image.method_4307(), image.method_4323(), false);
            for (int x = 0; x < image.method_4307(); ++x) {
                for (int y = 0; y < image.method_4323(); ++y) {
                    if (exclusion.includes(x, y)) {
                        copy.method_4305(x, y, image.method_4315(x, y));
                        continue;
                    }
                    copy.method_4305(x, y, pixelTransformation.applyAsInt(image.method_4315(x, y)));
                }
            }
            return copy;
        });
        LoadingCache cache = CacheBuilder.newBuilder().expireAfterAccess(15L, TimeUnit.MINUTES).build(CacheLoader.from(pair -> loader.loadAsync((class_2960)pair.left(), (TextureLoader.Exclusion)pair.right())));
        return (id, fallback, exclusion) -> {
            try {
                class_2960 class_29602 = ((CompletableFuture)cache.get(new Pair<class_2960, TextureLoader.Exclusion>(id, exclusion))).getNow(fallback);
                return class_29602;
            }
            catch (ExecutionException executionException) {
            }
            return fallback;
        };
    }

    public class_2960 load(class_2960 var1, class_2960 var2, TextureLoader.Exclusion var3);

    public static class_2960 getCyclicDefaultTexture() {
        byte[] randomBytes = new byte[16];
        new Random(System.currentTimeMillis() / 1000L).nextBytes(randomBytes);
        randomBytes[6] = (byte)(randomBytes[6] & 0xF);
        randomBytes[6] = (byte)(randomBytes[6] | 0x40);
        randomBytes[8] = (byte)(randomBytes[8] & 0x3F);
        randomBytes[8] = (byte)(randomBytes[8] | 0x80);
        return class_1068.method_4648((UUID)UUID.nameUUIDFromBytes(randomBytes));
    }

    public record Pair<A, B>(A left, B right) {
    }
}

