/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.hdskins.client.resources;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.minelittlepony.hdskins.client.resources.HDPlayerSkinTexture;
import com.minelittlepony.hdskins.client.resources.TextureLoader;
import com.minelittlepony.hdskins.profile.SkinType;
import com.mojang.authlib.GameProfile;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3695;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class SkinResourceManager
implements IdentifiableResourceReloadListener {
    private static final class_2960 ID = new class_2960("hdskins", "skins");
    private static final Logger logger = LogManager.getLogger();
    private static final Gson gson = new GsonBuilder().registerTypeHierarchyAdapter(SkinType.class, SkinType.adapter()).create();
    private final TextureLoader loader = new TextureLoader("hd_skins", HDPlayerSkinTexture::filterPlayerSkins);
    private final Map<SkinType, SkinStore> store = new HashMap<SkinType, SkinStore>();
    private final LoadingCache<class_2960, CompletableFuture<class_2960>> textures = CacheBuilder.newBuilder().expireAfterAccess(15L, TimeUnit.MINUTES).build(CacheLoader.from(this.loader::loadAsync));

    public CompletableFuture<Void> method_25931(class_3302.class_4045 sync, class_3300 sender, class_3695 serverProfiler, class_3695 clientProfiler, Executor serverExecutor, Executor clientExecutor) {
        sync.getClass();
        return sync.method_18352(null).thenRunAsync(() -> {
            clientProfiler.method_16065();
            clientProfiler.method_15396("Reloading User's HD Skins");
            this.store.clear();
            this.loader.stop();
            this.textures.invalidateAll();
            sender.method_14487().stream().map(domain -> new class_2960(domain, "textures/skins/skins.json")).forEach(identifier -> sender.method_14489(identifier).stream().map(this::loadSkinData).filter(Optional::isPresent).map(Optional::get).forEach(data -> data.skins.forEach(s -> this.store.computeIfAbsent(s.getType(), SkinStore::new).addSkin((SkinData.Skin)s))));
            clientProfiler.method_15407();
            clientProfiler.method_16066();
        }, clientExecutor);
    }

    public class_2960 getFabricId() {
        return ID;
    }

    private Optional<SkinData> loadSkinData(class_3298 res) {
        block8: {
            Optional<SkinData> optional;
            InputStreamReader reader = new InputStreamReader(res.method_14482());
            try {
                optional = Optional.ofNullable((SkinData)gson.fromJson((Reader)reader, SkinData.class));
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (JsonParseException e) {
                    logger.warn("Invalid skins.json in " + res.method_14480(), (Throwable)e);
                    break block8;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            reader.close();
            return optional;
        }
        return Optional.empty();
    }

    public Optional<class_2960> getCustomPlayerTexture(GameProfile profile, SkinType type) {
        return this.store.computeIfAbsent(type, SkinStore::new).getSkin(profile).map(SkinData.Skin::getTexture).map(id -> this.convertTexture(type, (class_2960)id));
    }

    public Optional<String> getCustomPlayerModel(GameProfile profile) {
        return this.store.computeIfAbsent(SkinType.SKIN, SkinStore::new).getSkin(profile).map(SkinData.Skin::getModel);
    }

    public class_2960 convertTexture(SkinType type, class_2960 identifier) {
        if (type != SkinType.SKIN) {
            return identifier;
        }
        return ((CompletableFuture)this.textures.getUnchecked((Object)identifier)).getNow(identifier);
    }

    static class SkinData {
        List<Skin> skins;

        SkinData() {
        }

        static class Skin {
            @Nullable
            private SkinType type;
            @Nullable
            String name;
            @Nullable
            UUID uuid;
            private String skin;
            @Nullable
            private String model;
            @Nullable
            private transient class_2960 texture;
            @Nullable
            private String pattern;
            @Nullable
            private transient Predicate<String> predicate;

            Skin() {
            }

            public String getModel() {
                return this.model == null ? "default" : this.model;
            }

            public class_2960 getTexture() {
                if (this.texture == null) {
                    this.texture = this.createTexture();
                }
                return this.texture;
            }

            private class_2960 createTexture() {
                if (this.skin.indexOf(47) > -1 || this.skin.indexOf(58) > -1 || this.skin.indexOf(46) > -1) {
                    if (this.skin.indexOf(46) == -1) {
                        this.skin = this.skin + ".png";
                    }
                    if (this.skin.indexOf(58) == -1) {
                        return new class_2960("hdskins", this.skin);
                    }
                    return new class_2960(this.skin);
                }
                return new class_2960("hdskins", String.format("textures/skins/%s.png", this.skin));
            }

            @Nullable
            public Predicate<String> getPredicate() {
                if (this.predicate == null && this.pattern != null) {
                    this.predicate = Pattern.compile(this.pattern).asPredicate();
                }
                return this.predicate;
            }

            public SkinType getType() {
                return this.type == null ? SkinType.SKIN : this.type;
            }
        }
    }

    static class SkinStore {
        private final List<SkinData.Skin> predicates = new ArrayList<SkinData.Skin>();
        private final Map<UUID, SkinData.Skin> uuids = new HashMap<UUID, SkinData.Skin>();
        private final Map<String, SkinData.Skin> names = new HashMap<String, SkinData.Skin>();

        SkinStore(SkinType type) {
        }

        public void addSkin(SkinData.Skin skin) {
            if (skin.skin != null) {
                if (skin.uuid != null) {
                    this.uuids.put(skin.uuid, skin);
                }
                if (skin.name != null) {
                    this.names.put(skin.name, skin);
                }
                if (skin.getPredicate() != null) {
                    this.predicates.add(skin);
                }
            }
        }

        @Nullable
        public Optional<SkinData.Skin> getSkin(GameProfile profile) {
            SkinData.Skin skin = this.uuids.get(profile.getId());
            if (skin == null && (skin = this.names.get(profile.getName())) == null) {
                return this.predicates.stream().filter(f -> f.getPredicate().test(profile.getName())).findFirst();
            }
            return Optional.ofNullable(skin);
        }
    }
}

