/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.hdskins.client.resources;

import com.minelittlepony.hdskins.client.VanillaModels;
import com.minelittlepony.hdskins.client.resources.HDPlayerSkinTexture;
import com.minelittlepony.hdskins.profile.SkinType;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1049;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import org.jetbrains.annotations.Nullable;

public interface Texture
extends AutoCloseable {
    public class_2960 getId();

    public boolean isLoaded();

    public static abstract class UriTexture
    extends HDPlayerSkinTexture
    implements Texture {
        private final String model;
        private final String fileUrl;
        private final class_2960 id;

        public static UriTexture create(class_2960 id, File cacheFile, String url, SkinType type, String model, class_2960 fallback, @Nullable Runnable callback) {
            final boolean[] uploaded = new boolean[1];
            return new UriTexture(id, cacheFile, url, type, model, fallback, () -> {
                uploaded[0] = true;
                if (callback != null) {
                    callback.run();
                }
            }){

                @Override
                public boolean isLoaded() {
                    return uploaded[0] && this.method_4624() > -1;
                }

                public void method_4528() {
                    super.method_4528();
                    uploaded[0] = false;
                }
            };
        }

        UriTexture(class_2960 id, File cacheFile, String url, SkinType type, String model, class_2960 fallback, Runnable callack) {
            super(cacheFile, url, type, fallback, callack);
            this.id = id;
            this.model = VanillaModels.of(model);
            this.fileUrl = url;
        }

        @Override
        public class_2960 getId() {
            return this.id;
        }

        public InputStream openStream() throws IOException {
            return new URL(this.fileUrl).openStream();
        }

        public boolean hasModel() {
            return this.model != null;
        }

        public boolean usesThinArms() {
            return VanillaModels.isSlim(this.model);
        }

        protected class_1049.class_4006 method_18153(class_3300 resourceManager) {
            class_1043 tex;
            class_1011 image;
            class_1044 class_10442;
            if (!resourceManager.method_14486(this.field_5224).isPresent() && (class_10442 = class_310.method_1551().method_1531().method_34590(this.field_5224, null)) instanceof class_1043 && (image = (tex = (class_1043)class_10442).method_4525()) != null) {
                class_1011 copy = new class_1011(image.method_4307(), image.method_4323(), true);
                copy.method_4317(image);
                return new class_1049.class_4006(null, copy);
            }
            return super.method_18153(resourceManager);
        }
    }

    public static class MemoryTexture
    extends class_1043
    implements Texture {
        private final class_2960 id;

        public MemoryTexture(class_1011 image, class_2960 id) {
            super(image);
            this.id = id;
        }

        @Override
        public class_2960 getId() {
            return this.id;
        }

        @Override
        public boolean isLoaded() {
            return this.method_4624() > -1;
        }
    }
}

