/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.hdskins.client.resources;

import com.minelittlepony.hdskins.client.HDSkins;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.BiFunction;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.jetbrains.annotations.Nullable;

public class TextureLoader {
    private static final class_310 CLIENT = class_310.method_1551();
    private ExecutorService executor = Executors.newSingleThreadExecutor();
    private final BiFunction<class_1011, Exclusion, class_1011> filter;
    private final String id;

    public static <T extends class_1044> T loadTexture(class_2960 textureLocation, T texture) {
        CLIENT.execute(() -> RenderSystem.recordRenderCall(() -> CLIENT.method_1531().method_4616(textureLocation, texture)));
        return texture;
    }

    public TextureLoader(String id, BiFunction<class_1011, Exclusion, class_1011> filter) {
        this.id = id;
        this.filter = filter;
    }

    public void stop() {
        this.executor.shutdownNow();
        this.executor = Executors.newSingleThreadExecutor();
    }

    public CompletableFuture<class_2960> loadAsync(class_2960 imageId) {
        return this.loadAsync(imageId, Exclusion.NULL);
    }

    public CompletableFuture<class_2960> loadAsync(class_2960 imageId, Exclusion exclusion) {
        return ((CompletableFuture)((CompletableFuture)CompletableFuture.supplyAsync(() -> this.getImage(imageId), this.executor).thenApplyAsync(loaded -> loaded.flatMap(image -> Optional.ofNullable(this.filter.apply((class_1011)image, exclusion)).filter(i -> i != null && i != image)), (Executor)CLIENT)).thenApplyAsync(updated -> updated.map(image -> {
            class_2960 convertedId = new class_2960(imageId.method_12836(), "dynamic/" + this.id + "/" + imageId.method_12832());
            CLIENT.method_1531().method_4616(convertedId, (class_1044)new class_1043(image));
            return convertedId;
        }).orElse(imageId), (Executor)CLIENT)).exceptionally(t -> {
            HDSkins.LOGGER.warn("Errored while processing {}. Using original.", (Object)imageId, t);
            return imageId;
        });
    }

    @Nullable
    private Optional<class_1011> getImage(class_2960 res) {
        class_1044 tex = CLIENT.method_1531().method_34590(res, (class_1044)null);
        if (tex instanceof class_1043) {
            class_1043 nat = (class_1043)tex;
            return Optional.ofNullable(nat.method_4525());
        }
        return CLIENT.method_1478().method_14486(res).map(resource -> {
            class_1011 class_10112;
            block8: {
                InputStream in = resource.method_14482();
                try {
                    class_10112 = class_1011.method_4309((InputStream)in);
                    if (in == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        HDSkins.LOGGER.warn("Errored while reading image file ({}): {}.", (Object)res, (Object)e);
                        return null;
                    }
                }
                in.close();
            }
            return class_10112;
        });
    }

    public static interface Exclusion {
        public static final Exclusion NULL = (x, y) -> false;

        public boolean includes(int var1, int var2);
    }
}

