/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.hdskins.profile;

import com.google.gson.TypeAdapter;
import com.minelittlepony.common.client.gui.sprite.ISprite;
import com.minelittlepony.common.client.gui.sprite.ItemStackSprite;
import com.minelittlepony.common.client.gui.sprite.TextureSprite;
import com.minelittlepony.common.client.gui.style.Style;
import com.minelittlepony.common.util.registry.Registries;
import com.minelittlepony.common.util.registry.RegistryTypeAdapter;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public class SkinType
implements Comparable<SkinType> {
    public static final SkinType UNKNOWN = new SkinType(new class_2960("hdskins", "unknown"), class_1799.field_8037);
    public static final class_2378<SkinType> REGISTRY = Registries.createDefaulted((class_2960)new class_2960("hdskins", "skin_type"), SkinType::getId, (Object)UNKNOWN);
    private static final TypeAdapter<SkinType> ADAPTER = RegistryTypeAdapter.of(REGISTRY, (ls, registry) -> registry.method_10220().filter(type -> type.getParameterizedName().equals(ls)).findFirst().orElseGet(() -> SkinType.createUnsupported(ls)));
    private static final Map<MinecraftProfileTexture.Type, SkinType> VANILLA = new EnumMap<MinecraftProfileTexture.Type, SkinType>(MinecraftProfileTexture.Type.class);
    public static final SkinType SKIN = SkinType.forVanilla(MinecraftProfileTexture.Type.SKIN, new class_1799((class_1935)class_1802.field_8577));
    public static final SkinType CAPE = SkinType.forVanilla(MinecraftProfileTexture.Type.CAPE, new class_1799((class_1935)class_1802.field_8077));
    public static final SkinType ELYTRA = SkinType.forVanilla(MinecraftProfileTexture.Type.ELYTRA, new class_1799((class_1935)class_1802.field_8833));
    private final class_2960 id;
    private final class_1799 iconStack;
    private final class_2960 icon;

    protected SkinType(class_2960 id, class_1799 iconStack) {
        this.id = id;
        this.icon = this.getId().method_45134(p -> "textures/gui/skin_type/" + p + ".png");
        this.iconStack = iconStack;
    }

    public class_2960 icon() {
        return this.icon;
    }

    public String name() {
        return this.getId().toString();
    }

    public String getParameterizedName() {
        return this.name().replace(':', '_').replace('/', '_').toLowerCase(Locale.US);
    }

    public String getPathName() {
        return this.getId().method_12836() + "/" + this.getId().method_12832();
    }

    public Style getStyle() {
        if (this.iconStack.method_7909() == class_1802.field_8077) {
            return new Style().setIcon((ISprite)new TextureSprite().setTexture(UNKNOWN.icon()).setPosition(2, 2).setSize(16, 16).setTextureSize(16, 16)).setText((class_2561)class_2561.method_43469((String)"skin_type.hdskins.unknown", (Object[])new Object[]{this.getId().toString()})).setTooltip(this.getId().toString(), 0, 10);
        }
        return new Style().setIcon((ISprite)(class_310.method_1551().method_1478().method_14486(this.icon).isEmpty() ? new ItemStackSprite().setStack(this.iconStack) : new TextureSprite().setTexture(this.icon).setPosition(2, 2).setSize(16, 16).setTextureSize(16, 16))).setText((class_2561)class_2561.method_43469((String)"hdskins.skin_type", (Object[])new Object[]{class_2561.method_43471((String)class_156.method_646((String)"skin_type", (class_2960)this.getId()))})).setTooltip(this.getId().toString(), 0, 10);
    }

    public final class_2960 getId() {
        return this.id;
    }

    public final int ordinal() {
        return REGISTRY.method_10206((Object)this);
    }

    public boolean isKnown() {
        return this != UNKNOWN;
    }

    public boolean isVanilla() {
        return this.getEnum().isPresent();
    }

    public Optional<MinecraftProfileTexture.Type> getEnum() {
        return Optional.empty();
    }

    public final boolean equals(Object other) {
        return other instanceof SkinType && this.compareTo((SkinType)other) == 0;
    }

    @Override
    public final int compareTo(SkinType o) {
        return this.getId().method_12833(o.getId());
    }

    public String toString() {
        return this.getId().toString();
    }

    public final int hashCode() {
        return this.getId().hashCode();
    }

    public static TypeAdapter<SkinType> adapter() {
        return ADAPTER;
    }

    public static Stream<SkinType> values() {
        return REGISTRY.method_10220();
    }

    private static SkinType createUnsupported(String parameterizedName) {
        return SkinType.register(SkinType.deParameterize(parameterizedName), class_1802.field_8077.method_7854());
    }

    private static class_2960 deParameterize(String parameterizedName) {
        String[] parts = parameterizedName.split("_", 2);
        parts[1] = parts[1].replace('_', '/');
        return new class_2960(parts[0], parts[1]);
    }

    public static SkinType register(class_2960 id, class_1799 iconStack) {
        return (SkinType)class_2378.method_10230(REGISTRY, (class_2960)id, (Object)new SkinType(id, iconStack));
    }

    public static SkinType forVanilla(MinecraftProfileTexture.Type vanilla) {
        return VANILLA.getOrDefault(vanilla, UNKNOWN);
    }

    public static SkinType forVanilla(MinecraftProfileTexture.Type vanilla, class_1799 iconStack) {
        return VANILLA.computeIfAbsent(vanilla, v -> new VanillaType(vanilla, iconStack));
    }

    private static final class VanillaType
    extends SkinType {
        private final Optional<MinecraftProfileTexture.Type> vanilla;

        VanillaType(MinecraftProfileTexture.Type vanilla, class_1799 iconStack) {
            super(new class_2960(vanilla.name().toLowerCase(Locale.US)), iconStack);
            this.vanilla = Optional.of(vanilla);
            class_2378.method_10230((class_2378)REGISTRY, (class_2960)this.getId(), (Object)this);
        }

        @Override
        public String name() {
            return this.vanilla.get().name();
        }

        @Override
        public Optional<MinecraftProfileTexture.Type> getEnum() {
            return this.vanilla;
        }
    }
}

