/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.hdskins.server;

import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.minelittlepony.hdskins.client.gui.SkinUploader;
import com.minelittlepony.hdskins.profile.SkinType;
import com.minelittlepony.hdskins.server.SkinServer;
import com.minelittlepony.hdskins.server.SkinUpload;
import com.minelittlepony.hdskins.server.TexturePayload;
import com.minelittlepony.hdskins.util.net.HttpException;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.exceptions.AuthenticationException;
import com.mojang.authlib.exceptions.AuthenticationUnavailableException;
import com.mojang.authlib.exceptions.InvalidCredentialsException;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.class_2561;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Gateway {
    private static final Logger LOGGER = LogManager.getLogger();
    private final SkinServer server;
    private final LoadingCache<GameProfile, CompletableFuture<Optional<SkinServer.SkinServerProfile<?>>>> profiles = CacheBuilder.newBuilder().expireAfterAccess(15L, TimeUnit.SECONDS).build(CacheLoader.from(this::loadUncachedProfile));
    private boolean offline;
    private boolean throttled;
    private boolean busy;

    public Gateway(SkinServer server) {
        this.server = server;
    }

    public boolean isOnline() {
        return !this.offline;
    }

    public void setOffline(boolean offline) {
        this.offline = offline;
    }

    public boolean isThrottled() {
        return this.throttled;
    }

    public void setThrottled(boolean throttled) {
        this.throttled = throttled;
    }

    public boolean isBusy() {
        return this.busy;
    }

    public void setBusy(boolean busy) {
        this.busy = busy;
    }

    public SkinServer getServer() {
        return this.server;
    }

    public Stream<SkinType> getSupportedSkinTypes() {
        return SkinType.REGISTRY.method_10220().filter(this.server::supportsSkinType).distinct();
    }

    private CompletableFuture<Optional<SkinServer.SkinServerProfile<?>>> loadUncachedProfile(GameProfile profile) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return this.server.loadProfile(profile);
            }
            catch (AuthenticationException | IOException e) {
                return Optional.empty();
            }
        });
    }

    public CompletableFuture<Optional<SkinServer.SkinServerProfile<?>>> getProfile(GameProfile profile) {
        return (CompletableFuture)this.profiles.getUnchecked((Object)profile);
    }

    public void invalidateProfile(GameProfile profile) {
        this.profiles.invalidate((Object)profile);
    }

    public CompletableFuture<Void> uploadSkin(SkinUpload payload, Consumer<class_2561> errorCallback) {
        return CompletableFuture.runAsync(() -> {
            try {
                this.setBusy(true);
                this.server.uploadSkin(payload);
                this.invalidateProfile(payload.session().profile());
            }
            catch (Exception e) {
                this.handleException(e, errorCallback);
            }
            finally {
                this.setBusy(false);
            }
        });
    }

    public <K extends SkinServer.SkinServerProfile.Skin> CompletableFuture<Void> swapSkin(SkinServer.SkinServerProfile<K> profile, SkinType type, int index, Consumer<class_2561> errorCallback) {
        return CompletableFuture.runAsync(() -> {
            try {
                this.setBusy(true);
                profile.setActive(type, (SkinServer.SkinServerProfile.Skin)profile.getSkins(type).get(index));
                this.invalidateProfile(profile.getGameProfile());
            }
            catch (Exception e) {
                this.handleException(e, errorCallback);
            }
            finally {
                this.setBusy(false);
            }
        });
    }

    public CompletableFuture<TexturePayload> fetchSkins(GameProfile profile, SkinUpload.Session session, Consumer<class_2561> errorCallback) {
        CompletableFuture.runAsync(() -> {
            try {
                this.server.authorize(session);
            }
            catch (Throwable e) {
                this.handleException(e, t -> {});
            }
        });
        return CompletableFuture.supplyAsync(() -> {
            try {
                this.setBusy(true);
                TexturePayload texturePayload = this.server.loadSkins(profile);
                return texturePayload;
            }
            catch (Exception e) {
                this.handleException(e, errorCallback);
                throw new RuntimeException(e);
            }
            finally {
                this.setBusy(false);
            }
        });
    }

    public void handleException(Throwable throwable, Consumer<class_2561> errorCallback) {
        throwable = Throwables.getRootCause((Throwable)throwable);
        this.setBusy(false);
        if (throwable instanceof HttpException) {
            HttpException ex = (HttpException)throwable;
            int code = ex.getStatusCode();
            if (code >= 500) {
                LOGGER.error(ex.getReasonPhrase(), (Throwable)ex);
                errorCallback.accept((class_2561)class_2561.method_43470((String)("A fatal server error has ocurred (check logs for details): \n" + ex.getReasonPhrase())));
            } else if (code >= 400 && code != 403 && code != 404) {
                LOGGER.error(ex.getReasonPhrase(), (Throwable)ex);
                errorCallback.accept((class_2561)class_2561.method_43470((String)ex.getReasonPhrase()));
            } else {
                LOGGER.error(ex.getReasonPhrase(), (Throwable)ex);
            }
        } else {
            LOGGER.error("Unexpected error whilst contacting server at " + this.server.toString(), throwable);
            if (throwable instanceof AuthenticationUnavailableException) {
                this.setOffline(true);
            } else if (throwable instanceof InvalidCredentialsException) {
                errorCallback.accept(SkinUploader.ERR_SESSION);
            } else if (throwable instanceof AuthenticationException) {
                this.setThrottled(true);
            } else {
                LOGGER.error("Unhandled exception", throwable);
                errorCallback.accept((class_2561)class_2561.method_43470((String)throwable.toString()));
            }
        }
    }
}

