/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.hdskins.server;

import com.minelittlepony.hdskins.profile.SkinType;
import com.minelittlepony.hdskins.server.Feature;
import com.minelittlepony.hdskins.server.SkinUpload;
import com.minelittlepony.hdskins.server.TexturePayload;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.exceptions.AuthenticationException;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public interface SkinServer {
    public Set<Feature> getFeatures();

    public boolean ownsUrl(String var1);

    public boolean supportsSkinType(SkinType var1);

    public void authorize(SkinUpload.Session var1) throws IOException, AuthenticationException;

    public TexturePayload loadSkins(GameProfile var1) throws IOException, AuthenticationException;

    public void uploadSkin(SkinUpload var1) throws IOException, AuthenticationException;

    default public Optional<SkinServerProfile<?>> loadProfile(GameProfile profile) throws IOException, AuthenticationException {
        return Optional.empty();
    }

    public static interface SkinServerProfile<T extends Skin> {
        public GameProfile getGameProfile();

        public List<T> getSkins(SkinType var1);

        public void setActive(SkinType var1, T var2);

        public static interface Skin {
            public String getModel();

            public boolean isActive();

            public String getUri();
        }
    }
}

