/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.hdskins.server;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.minelittlepony.hdskins.profile.ProfileUtils;
import com.minelittlepony.hdskins.profile.SkinType;
import com.minelittlepony.hdskins.server.Gateway;
import com.minelittlepony.hdskins.server.SkinServer;
import com.minelittlepony.hdskins.server.SkinServerSerializer;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_4013;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SkinServerList
implements class_4013,
IdentifiableResourceReloadListener {
    private static final class_2960 SKIN_SERVERS = new class_2960("hdskins", "skins/servers.json");
    private static final Logger logger = LogManager.getLogger();
    private static final Gson gson = new GsonBuilder().registerTypeAdapter(SkinServer.class, (Object)SkinServerSerializer.instance).create();
    private List<Gateway> skinServers = new LinkedList<Gateway>();

    public class_2960 getFabricId() {
        return SKIN_SERVERS;
    }

    public void method_14491(class_3300 mgr) {
        this.skinServers.clear();
        logger.info("Loading skin servers");
        for (class_3298 res : mgr.method_14489(SKIN_SERVERS)) {
            logger.info("Found {} in {}", (Object)SKIN_SERVERS, (Object)res.method_14480());
            try (InputStreamReader reader = new InputStreamReader(res.method_14482());){
                SkinServerJson json = (SkinServerJson)gson.fromJson((Reader)reader, SkinServerJson.class);
                json.apply(this.skinServers);
            }
            catch (JsonParseException | IOException e) {
                logger.warn("Unable to load resource '{}' from '{}'", (Object)SKIN_SERVERS, (Object)res.method_14480(), (Object)e);
            }
        }
    }

    public List<Gateway> getSkinServers() {
        return ImmutableList.copyOf(this.skinServers);
    }

    public Stream<Map<SkinType, MinecraftProfileTexture>> getEmbeddedTextures(GameProfile profile) {
        return ProfileUtils.readCustomBlob(profile, "hd_textures", ProfileUtils.TextureData.class).map(ProfileUtils.TextureData::getTextures).filter(this::isUrlPermitted);
    }

    private boolean isUrlPermitted(Map<SkinType, MinecraftProfileTexture> blob) {
        return blob.values().stream().map(MinecraftProfileTexture::getUrl).allMatch(url -> this.skinServers.stream().anyMatch(s -> s.getServer().ownsUrl((String)url)));
    }

    public Iterator<Gateway> getCycler() {
        return Iterators.cycle(this.getSkinServers());
    }

    private static <T> void addAllStart(List<T> list, List<T> toAdd) {
        list.addAll(0, toAdd);
    }

    private static class SkinServerJson {
        boolean overwrite = false;
        InsertType insert = InsertType.END;
        List<SkinServer> servers = Collections.emptyList();

        private SkinServerJson() {
        }

        private void apply(List<Gateway> skinServers) {
            if (this.overwrite) {
                skinServers.clear();
            }
            logger.info("Found {} servers", (Object)this.servers.size());
            this.insert.consumer.accept(skinServers, this.servers.stream().map(Gateway::new).toList());
        }
    }

    private static enum InsertType {
        START(SkinServerList::addAllStart),
        END(List::addAll);

        final BiConsumer<List<Gateway>, List<Gateway>> consumer;

        private InsertType(BiConsumer<List<Gateway>, List<Gateway>> consumer) {
            this.consumer = consumer;
        }
    }
}

