/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.hdskins.server;

import com.minelittlepony.hdskins.profile.SkinType;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.exceptions.AuthenticationException;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface SkinUpload {
    public Session session();

    public SkinType type();

    public static SkinUpload delete(SkinType type, Session session) {
        return SkinUpload.create(null, type, Map.of(), session);
    }

    public static SkinUpload create(@Nullable URI skin, SkinType type, Map<String, String> metadata, Session session) {
        if (skin == null) {
            return new Delete(session, type);
        }
        if ("file".equals(skin.getScheme())) {
            return new FileUpload(session, type, Paths.get(skin), metadata);
        }
        if (Set.of("http", "https").contains(skin.getScheme())) {
            return new UriUpload(session, type, skin, metadata);
        }
        throw new IllegalArgumentException("URI scheme not supported for skin upload: " + skin.getScheme());
    }

    public record Session(GameProfile profile, String accessToken, Validator validator) {
        public void validate(String serverId) throws AuthenticationException {
            this.validator.accept(this, serverId);
        }

        public boolean hasFailedValidation() {
            return !this.validator.valid;
        }

        public static Validator validator(ValidateFunction function) {
            return new Validator(function);
        }

        static final class Validator {
            private boolean valid = true;
            private final ValidateFunction function;

            Validator(ValidateFunction function) {
                this.function = function;
            }

            public void accept(Session session, String serverId) throws AuthenticationException {
                this.valid = false;
                this.function.accept(session, serverId);
                this.valid = true;
            }
        }

        public static interface ValidateFunction {
            public void accept(Session var1, String var2) throws AuthenticationException;
        }
    }

    public record Delete(Session session, SkinType type) implements SkinUpload
    {
    }

    public record FileUpload(Session session, SkinType type, Path file, Map<String, String> metadata) implements SkinUpload
    {
    }

    public record UriUpload(Session session, SkinType type, URI uri, Map<String, String> metadata) implements SkinUpload
    {
    }
}

