/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.hdskins.server;

import com.minelittlepony.hdskins.client.HDSkins;
import com.minelittlepony.hdskins.profile.SkinType;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;

public class TexturePayload {
    private long timestamp;
    private UUID profileId;
    private String profileName;
    private boolean isPublic;
    private Map<SkinType, MinecraftProfileTexture> textures;

    TexturePayload() {
    }

    public TexturePayload(GameProfile profile, Map<SkinType, MinecraftProfileTexture> textures) {
        this.profileId = profile.getId();
        this.profileName = profile.getName();
        this.timestamp = System.currentTimeMillis();
        this.isPublic = true;
        this.textures = new HashMap<SkinType, MinecraftProfileTexture>(textures);
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public UUID getProfileId() {
        return this.profileId;
    }

    public String getProfileName() {
        return this.profileName;
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    public Map<SkinType, MinecraftProfileTexture> getTextures() {
        return this.textures;
    }

    public Optional<MinecraftProfileTexture> getTexture(SkinType type) {
        return this.textures.containsKey(type) ? Optional.of(this.textures.get(type)) : Optional.empty();
    }

    public static class Textures
    extends HashMap<SkinType, MinecraftProfileTexture> {
        private static final long serialVersionUID = 8314133197016994678L;

        public Textures(Map<SkinType, MinecraftProfileTexture> textures) {
            this.putAll(textures);
        }

        public Textures() {
        }

        @Override
        public MinecraftProfileTexture put(SkinType type, MinecraftProfileTexture texture) {
            if ((texture = super.put(type, texture)) != null) {
                HDSkins.LOGGER.warn("Duplicate texture for skin type " + String.valueOf(type));
            }
            return null;
        }
    }
}

