/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.hdskins.server;

import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.minelittlepony.hdskins.profile.SkinType;
import com.minelittlepony.hdskins.server.Feature;
import com.minelittlepony.hdskins.server.ServerType;
import com.minelittlepony.hdskins.server.SkinServer;
import com.minelittlepony.hdskins.server.SkinUpload;
import com.minelittlepony.hdskins.server.TexturePayload;
import com.minelittlepony.hdskins.util.IndentedToStringStyle;
import com.minelittlepony.hdskins.util.net.FileTypes;
import com.minelittlepony.hdskins.util.net.HttpException;
import com.minelittlepony.hdskins.util.net.MoreHttpResponses;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.exceptions.AuthenticationException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpRequest;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.class_156;
import net.minecraft.class_310;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.message.BasicNameValuePair;

@ServerType(value="valhalla")
public class ValhallaSkinServer
implements SkinServer {
    private static final String API_PREFIX = "/api/v1";
    private static final Set<Feature> FEATURES = Sets.newHashSet((Object[])new Feature[]{Feature.DOWNLOAD_USER_SKIN, Feature.UPLOAD_USER_SKIN, Feature.DELETE_USER_SKIN, Feature.MODEL_VARIANTS, Feature.MODEL_TYPES});
    private final String address;
    private transient String accessToken;

    public ValhallaSkinServer(String address) {
        this.address = address;
    }

    private static NameValuePair param(String name, String value) {
        return new BasicNameValuePair(name, value);
    }

    private URI buildBackendUri(String path, NameValuePair ... params) {
        try {
            return new URIBuilder(this.address + "/api/v1/" + path).setParameters(params).build();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Failed to build URI", e);
        }
    }

    private URI buildBackendUserUri(UUID uuid) {
        return this.buildBackendUri(String.format("user/%s", uuid.toString()), new NameValuePair[0]);
    }

    private URI buildBackendHistoryUri(UUID uuid) {
        return this.buildBackendUri(String.format("history/%s", uuid.toString()), new NameValuePair[0]);
    }

    @Override
    public Set<Feature> getFeatures() {
        return FEATURES;
    }

    @Override
    public boolean supportsSkinType(SkinType skinType) {
        return skinType.isKnown() && skinType != SkinType.CAPE;
    }

    @Override
    public boolean ownsUrl(String url) {
        try {
            url = new URI(url).getHost();
            String domain = new URI(this.address).getHost();
            return domain.contentEquals(url) || url.startsWith("textures") && domain.contentEquals(url.replace("textures", "skins"));
        }
        catch (URISyntaxException uRISyntaxException) {
            return false;
        }
    }

    @Override
    public TexturePayload loadSkins(GameProfile profile) throws IOException, AuthenticationException {
        URI path = this.buildBackendUserUri(profile.getId());
        return MoreHttpResponses.execute(HttpRequest.newBuilder(path).GET().build()).requireOk().json(TexturePayload.class, "Invalid texture payload");
    }

    public TexturePayload loadSkins(SkinUpload.Session session) throws IOException, AuthenticationException {
        this.authorize(session);
        return this.doAuthorizedRequest(session, accessToken -> new TexturePayload(session.profile(), MoreHttpResponses.execute(HttpRequest.newBuilder(this.buildBackendUri("textures", new NameValuePair[0])).GET().header("Authorization", accessToken).build()).requireOk().json(TexturePayload.Textures.class, "Invalid texture payload")));
    }

    @Override
    public void uploadSkin(SkinUpload upload) throws IOException, AuthenticationException {
        this.doAuthorizedRequest(upload.session(), accessToken -> {
            if (upload instanceof SkinUpload.Delete) {
                return MoreHttpResponses.execute(HttpRequest.newBuilder(this.buildBackendUri("textures", ValhallaSkinServer.param("type", upload.type().getParameterizedName()))).DELETE().header("Authorization", accessToken).build()).requireOk();
            }
            if (upload instanceof SkinUpload.FileUpload) {
                SkinUpload.FileUpload fileUpload = (SkinUpload.FileUpload)upload;
                return MoreHttpResponses.execute(HttpRequest.newBuilder(this.buildBackendUri("textures", new NameValuePair[0])).PUT(FileTypes.multiPart().field("type", fileUpload.type().getParameterizedName()).field("file", fileUpload.file()).field("meta", new Gson().toJson(fileUpload.metadata())).build()).header("Content-Type", "multipart/form-data; boundary=\"MULTI-PART_BOUNDARY\"").header("Accept", "application/json").header("Authorization", accessToken).build()).requireOk();
            }
            if (upload instanceof SkinUpload.UriUpload) {
                SkinUpload.UriUpload uriUpload = (SkinUpload.UriUpload)upload;
                return MoreHttpResponses.execute(HttpRequest.newBuilder(this.buildBackendUri("textures", new NameValuePair[0])).POST(FileTypes.json(Map.of("type", uriUpload.type().getParameterizedName(), "file", uriUpload.uri().toString(), "meta", uriUpload.metadata()))).header("Content-Type", "application/json").header("Accept", "application/json").header("Authorization", accessToken).build()).requireOk();
            }
            throw new IOException("Unrecognised upload type");
        });
    }

    @Override
    public void authorize(SkinUpload.Session session) throws IOException, AuthenticationException {
        if (this.accessToken != null) {
            return;
        }
        GameProfile profile = session.profile();
        AuthHandshake handshake = this.authHandshake(profile.getName());
        if (handshake.offline) {
            return;
        }
        session.validate(handshake.serverId);
        AuthResponse response = this.authResponse(profile.getName(), handshake.verifyToken);
        if (!response.userId.equals(profile.getId())) {
            throw new IOException("UUID mismatch!");
        }
        this.accessToken = response.accessToken;
    }

    @Override
    public Optional<SkinServer.SkinServerProfile<?>> loadProfile(final GameProfile profile) throws IOException, AuthenticationException {
        return MoreHttpResponses.execute(HttpRequest.newBuilder(this.buildBackendHistoryUri(profile.getId())).GET().build()).accept(r -> r.json(Textures.class, "Server sent invalid profile response")).map(p -> {
            final Function textures = class_156.method_34866(type -> {
                HashSet visited = new HashSet();
                return p.textures().getOrDefault(type, List.of()).stream().filter(texture -> visited.add(texture.url + texture.getModel())).sorted(Comparator.comparing(t -> -t.startTime)).toList();
            });
            return new SkinServer.SkinServerProfile<Texture>(){

                @Override
                public List<Texture> getSkins(SkinType type) {
                    return (List)textures.apply(type);
                }

                @Override
                public void setActive(SkinType type, Texture texture) {
                    try {
                        ValhallaSkinServer.this.uploadSkin(new SkinUpload.UriUpload(new SkinUpload.Session(profile, class_310.method_1551().method_1548().method_1674(), SkinUpload.Session.validator((session, serverId) -> class_310.method_1551().method_1495().joinServer(session.profile(), session.accessToken(), serverId))), type, URI.create(texture.getUri()), texture.metadata));
                    }
                    catch (AuthenticationException | IOException e) {
                        e.printStackTrace();
                    }
                }

                @Override
                public GameProfile getGameProfile() {
                    return profile;
                }
            };
        });
    }

    private <T> T doAuthorizedRequest(SkinUpload.Session session, AuthorizedRequest<T> requester) throws IOException, AuthenticationException {
        this.authorize(session);
        try {
            return requester.doRequest(this.accessToken);
        }
        catch (HttpException e) {
            if (e.getStatusCode() != 401) {
                throw e;
            }
            this.accessToken = null;
            this.authorize(session);
            return requester.doRequest(this.accessToken);
        }
        catch (IOException e) {
            if (e.getMessage().equals("Authorization failed")) {
                this.accessToken = null;
                this.authorize(session);
                return requester.doRequest(this.accessToken);
            }
            throw e;
        }
    }

    private AuthHandshake authHandshake(String name) throws IOException {
        return MoreHttpResponses.execute(HttpRequest.newBuilder(this.buildBackendUri("auth/minecraft", new NameValuePair[0])).POST(FileTypes.multiPart().field("name", name).build()).header("Content-Type", "multipart/form-data; boundary=\"MULTI-PART_BOUNDARY\"").header("Accept", "application/json").build()).requireOk().json(AuthHandshake.class, "Invalid handshake response");
    }

    private AuthResponse authResponse(String name, long verifyToken) throws IOException {
        return MoreHttpResponses.execute(HttpRequest.newBuilder(this.buildBackendUri("auth/minecraft/callback", new NameValuePair[0])).POST(FileTypes.multiPart().field("name", name).field("verifyToken", verifyToken).build()).header("Content-Type", "multipart/form-data; boundary=\"MULTI-PART_BOUNDARY\"").header("Accept", "application/json").build()).requireOk().json(AuthResponse.class, "Invalid auth response");
    }

    public String toString() {
        return new IndentedToStringStyle.Builder(this).append("address", this.address).toString();
    }

    private static interface AuthorizedRequest<T> {
        public T doRequest(String var1) throws IOException, AuthenticationException;
    }

    private record AuthHandshake(boolean offline, String serverId, long verifyToken) {
    }

    private record AuthResponse(String accessToken, UUID userId) {
    }

    private record Textures(String profileId, String profilename, Map<SkinType, List<Texture>> textures) {
    }

    private record Texture(long startTime, String endTime, Map<String, String> metadata, String url) implements SkinServer.SkinServerProfile.Skin
    {
        @Override
        public String getModel() {
            return this.metadata.get("model");
        }

        @Override
        public boolean isActive() {
            return this.endTime == null || "null".equalsIgnoreCase(this.endTime);
        }

        @Override
        public String getUri() {
            return this.url;
        }
    }
}

